 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Miniport support routines.
  * </DOC_AMD_STD>
  * 
  */

#include "dderror.h"
#include "devioctl.h"
#include "miniport.h"

#if _WIN32_WINNT >= 0x0500
#include "ntddvdeo.h"
#endif //_WIN32_WINNT >= 0x500

#include "video.h"
#include "gxdrv.h"
#include "debug.h"
#include "gfx_rtns.h"
#include "gxmode.h"
#include "gfx_regs.h"

extern unsigned short ModeHeight;
extern unsigned short PanelEnable;
extern int gfx_compression_enabled;
extern int gfx_compression_active;
extern void gfx_outb (unsigned short port, unsigned char data);
extern unsigned char gfx_inb (unsigned short port);

/*------------------------------------------------------------------------- 
 * GXWaitForVSyncEnd
 * 
 * Waits for at least 1 Full rise and fall of Vsync.
 -------------------------------------------------------------------------*/

void GXWaitForVsyncEnd()
{
	if (gfx_test_timing_active())
	{
		/* WAIT FOR END OF CURRENT VSYNC (IF NEEDED) */

		while (!gfx_test_vertical_active());

		/* WAIT FOR NEXT VSYNC */

		while (gfx_test_vertical_active());

		/* POLL UNTIL THE END OF VSYNC                                */
		/* This guarantees that at least one full VSync has occurred. */

		while (!gfx_test_vertical_active());
	}
}

/*-------------------------------------------------------------------------
 * GXSetDisplayMode
 *
 * Set the display mode requested by the display driver. There is a handshake
 * on startup where the display driver requests from the miniport a list
 * of all supported modes. The display driver picks the one it likes the
 * best from the list and requests the miniort to establish that mode.
 *
 * display_mode: index of the chosen mode.
 -------------------------------------------------------------------------*/

VP_STATUS GXSetDisplayMode(
	HW_DEVICE_EXTENSION *HwDeviceExtension,
	int display_mode)
{
	unsigned char sequencer;

	/* DISABLE VGA SEQUENCER */
	/* This allows the VGA state machine to terminate.  We must delay, such that */
	/* no there are no pending MBUS requests.                                    */
	
	gfx_outb (MDC_SEQUENCER_INDEX, MDC_SEQUENCER_CLK_MODE);
	sequencer  = gfx_inb (MDC_SEQUENCER_DATA);
	sequencer |= MDC_CLK_MODE_SCREEN_OFF;
	gfx_outb (MDC_SEQUENCER_DATA, sequencer);
	
	gfx_delay_milliseconds(1);

	/* BLANK THE VGA DISPLAY */

	gfx_outb (MDC_SEQUENCER_INDEX, MDC_SEQUENCER_RESET);
	sequencer   = gfx_inb (MDC_SEQUENCER_DATA);
	sequencer &= ~MDC_RESET_VGA_DISP_ENABLE;
	gfx_outb (MDC_SEQUENCER_DATA, sequencer);

	/* SET THE MODE */
	
	if (HwDeviceExtension->PanelWidth)
	{
		DISPDBG((2000, "Panel %d %d \n",
			HwDeviceExtension->PanelWidth,
			HwDeviceExtension->PanelHeight));
			
		/* BLOW AWAY BIOS TIMINGS FOR NOW */

		gfx_set_fixed_timings (
			HwDeviceExtension->PanelWidth,
			HwDeviceExtension->PanelHeight,
			(USHORT)HwDeviceExtension->ScreenWidth,
			(USHORT)HwDeviceExtension->ScreenHeight,
			(USHORT)HwDeviceExtension->BitsPerPixel);

		/* SET THE PANEL BACKGROUND COLOR */
		/* When the display mode is smaller than the panel resolution */
		/* panel centering is enabled.  This effectively creates a    */
		/* solid border around the display mode.  We initialize this  */
		/* color to be black.  Note that this color is actually one   */
		/* of the icon colors, so we can cheat and simply set the     */
		/* icon colors in Durango.                                    */

		gfx_set_icon_colors (0, 0, 0);
	} 
	else 
	{			
		gfx_set_display_mode(HwDeviceExtension->ScreenWidth, 
			                 HwDeviceExtension->ScreenHeight,
							 HwDeviceExtension->BitsPerPixel, 
							 HwDeviceExtension->VRefreshRate);
	}

	/* SET THE APPROPRIATE STRIDE */

	gfx_set_display_pitch ((unsigned short)HwDeviceExtension->ScreenStride);

	/* DISABLE THE CRT */
	/* The CRT is only enabled once all bitmaps have been deleted and the */
	/* screen has been blanked                                            */

	gfx_set_crt_enable(0);

	/* SET CURSOR COLOR KEY */

	gfx_set_video_cursor (0x00FCFEFD, 0xFFFFFFFF, 0, 0xFCFEFD, 0xFCFEFD);
	gfx_set_video_cursor_enable (1);

	/* SET CURSOR TO 20K BEFORE THE END OF FB SPACE */
	/* 16K for scratch space and 4K for cursor data */

	HwDeviceExtension->CursorOffset = HwDeviceExtension->FBSize - 0x5000;

	if(HwDeviceExtension->Compression)
	{
		/* CONFIGURE COMPRESSION PARAMETERS */
		/* Compression will only be enabled once all bitmaps have been deleted */
		/* from the previous mode to prevent corruption.                       */
		
		gfx_set_compression_offset (gfx_get_display_pitch() * HwDeviceExtension->ScreenHeight);
		gfx_set_compression_pitch (544);
		gfx_set_compression_size (544);

		/* FOOL DURANGO */
		/* We cannot enable compression yet, because it may corrupt bitmaps that */
		/* not yet been transferred out of video memory.  However, as Durango is */
		/* used to pan a virtual desktop, it must be aware of the compression    */
		/* status.                                                               */
		
		if (HwDeviceExtension->ModeFlags & DRIVER_FLAG_COMPRESSION)
		{
			gfx_compression_active  = 1;
			gfx_compression_enabled = 1;
		}
	}

	return(1);
}

/*-------------------------------------------------------------------------
 * GetOffscreenStart
 *
 * retuns the start of OffScreen memory.
 -------------------------------------------------------------------------*/
ULONG GetOffscreenStart()
{
	if (PanelEnable)
		return ((gfx_get_display_pitch() * (ULONG)ModeHeight) + (544 * (ULONG)gfx_get_vactive()));
	else	
		return ((gfx_get_display_pitch() * (ULONG)gfx_get_vactive()) + (544 * (ULONG)gfx_get_vactive()));
}

/*-------------------------------------------------------------------------
 * GetOffscreenEnd
 *
 * retuns the end of OffScreen memory.
 -------------------------------------------------------------------------*/
ULONG GetOffscreenEnd()
{
	return (gfx_get_frame_buffer_size() - 0x5000);
}

/*-------------------------------------------------------------------------
 * GXSetMode3
 *
 * Set the display mode to mode 3 (VGA 80-column text).
 -------------------------------------------------------------------------*/

VP_STATUS GXSetMode3 (HW_DEVICE_EXTENSION *HwDeviceExtension)
{
	VP_STATUS status;
	ULONG i;
	VIDEO_X86_BIOS_ARGUMENTS biosArguments;

	DISPDBG((1, "GXSetMode3\n"));

	VideoPortZeroMemory(&biosArguments, sizeof(biosArguments));

	/* SET MODE 3 (AH = 00h, AL = 03h) */
	
	biosArguments.Eax = 0x0003;
	biosArguments.Ebx = 0;
	status = VideoPortInt10(HwDeviceExtension, &biosArguments);

	DISPDBG((1, "Status from set mode %x\n", status));
	return(status);
}

