 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Miniport predefined routines.
  * </DOC_AMD_STD>
  * 
  */

//
//Length - Length of the structure in bytes. Also used to do verisioning.
//
//ModeIndex - Number used to set this mode when calling the miniport driver.
//
//VisScreenWidth - Number of visible horizontal pixels on a scan line
//
//VisScreenHeight - Number of visible lines (or scan lines)
//
//ScreenStride - Delta, in *BYTES*, between the start of two scan lines.
//
//    NOTE: the width and height are in pixels, but the stride is in bytes !!!
//
//NumberOfPlanes - Number of separate planes combined by the device.
//
//BitsPerPlane - Number of bits per pixel on a plane.
//
//Frequency - Screen Frequency, in Hertz.
//
//XMillimeter - Size of the horizontal active region on the output device,
//    in millimeters.
//
//YMillimeter - Size of the vertical active region on the output device,
//    in millimeters.
//
//NumberRedBits - Number of bits in the red DAC.
//
//NumberGreenBits - Number of bits in the green DAC.
//
//NumberBlueBits - Number of bits in the blue DAC.
//
//RedMask - Red color Mask for device with direct color modes. Bits turned
//    on indicate the bit is of color Red.
//
//GreenMask - Green color Mask for device with direct color modes. Bits
//    turned on indicate the bit is of color Green.
//
//BlueMask - Blue color Mask for device with direct color modes. Bits
//    turned on indicate the bit is of color Blue.
//
//AttributeFlags. Flags indicating certain behavior for the device.
//
//VideoMemoryBitmapWidth - Width of the video memory bitmap.
//    VisScreenWidth <= VideoMemoryBitmapWidth <= ScreenStride
//
//VideoMemoryBitmapHeight - Height of the video memory bitmap.
//   VisScreenHeight <= VideoMemoryBitmapHeight = VideoRamLength / ScreenStride
//
//DriverSpecificAttributeFlags - Flags indicating certain behavior for the
//   device that are private to the miniport\display driver.
//

GXVideoMode gxVideoModes[] =
{
	{
		0x101,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	 /* 640 x 480 x 8 */
			0,		/* ModeIndex */
			640,	/* VisScreenWidth */
			480,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			60, 	/* Frequency */
			320,	/* XMillimeter */
			240,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MONO_POINTER |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			480,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x101,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	 /* 640 x 480 x 8 */
			0,		/* ModeIndex */
			640,	/* VisScreenWidth */
			480,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			70, 	/* Frequency */
			320,	/* XMillimeter */
			240,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MONO_POINTER |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			480,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x101,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	 /* 640 x 480 x 8 */
			0,		/* ModeIndex */
			640,	/* VisScreenWidth */
			480,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			72, 	/* Frequency */
			320,	/* XMillimeter */
			240,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MONO_POINTER |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			480,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x101,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	 /* 640 x 480 x 8 */
			0,		/* ModeIndex */
			640,	/* VisScreenWidth */
			480,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			75, 	/* Frequency */
			320,	/* XMillimeter */
			240,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MONO_POINTER |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			480,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x101,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	 /* 640 x 480 x 8 */
			0,		/* ModeIndex */
			640,	/* VisScreenWidth */
			480,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			85, 	/* Frequency */
			320,	/* XMillimeter */
			240,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MONO_POINTER |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			480,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x101,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	 /* 640 x 480 x 8 */
			0,		/* ModeIndex */
			640,	/* VisScreenWidth */
			480,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			90, 	/* Frequency */
			320,	/* XMillimeter */
			240,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MONO_POINTER |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			480,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x101,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	 /* 640 x 480 x 8 */
			0,		/* ModeIndex */
			640,	/* VisScreenWidth */
			480,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			100, 	/* Frequency */
			320,	/* XMillimeter */
			240,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MONO_POINTER |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			480,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 16 (5-6-5) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			60, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 16 (5-6-5) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			70, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 16 (5-6-5) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			72, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 16 (5-6-5) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			75, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 16 (5-6-5) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			85, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 16 (5-6-5) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			90, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 16 (5-6-5) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			100, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 32 (8-8-8) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			60, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xff<<16,	/* Red mask */
			0xff<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 32 (8-8-8) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			70, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xff<<16,	/* Red mask */
			0xff<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 32 (8-8-8) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			72, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 32 (8-8-8) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			75, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 32 (8-8-8) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			85, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 32 (8-8-8) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			90, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x111,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	640 x 480 x 32 (8-8-8) */
			0,		/* ModeIndex */
			640,	/* Screen Width */
			480,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			100, 	/* Monitor frequency */
			320,	/* X millimeter */
			240,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			480,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x103,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 8 */
			0,		/* ModeIndex */
			800,	/* VisScreenWidth */
			600,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			60, 	/* Frequency */
			400,	/* XMillimeter */
			300,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			600,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
    {
		0x103,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 8 */
			0,		/* ModeIndex */
			800,	/* VisScreenWidth */
			600,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			70, 	/* Frequency */
			400,	/* XMillimeter */
			300,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			600,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
	{
		0x103,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 8 */
			0,		/* ModeIndex */
			800,	/* VisScreenWidth */
			600,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			72, 	/* Frequency */
			400,	/* XMillimeter */
			300,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			600,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
	{
		0x103,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 8 */
			0,		/* ModeIndex */
			800,	/* VisScreenWidth */
			600,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			75, 	/* Frequency */
			400,	/* XMillimeter */
			300,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			600,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
	{
		0x103,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 8 */
			0,		/* ModeIndex */
			800,	/* VisScreenWidth */
			600,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			85, 	/* Frequency */
			400,	/* XMillimeter */
			300,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			600,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
    {
		0x103,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 8 */
			0,		/* ModeIndex */
			800,	/* VisScreenWidth */
			600,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			90, 	/* Frequency */
			400,	/* XMillimeter */
			300,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			600,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
    {
		0x103,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 8 */
			0,		/* ModeIndex */
			800,	/* VisScreenWidth */
			600,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			100, 	/* Frequency */
			400,	/* XMillimeter */
			300,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN |
				VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			600,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
	{
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 16 (5-6-5) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			2048,	/* Screen Stride  */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			60, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 16 (5-6-5) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			2048,	/* Screen Stride  */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			70, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 16 (5-6-5) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			2048,	/* Screen Stride  */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			72, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 16 (5-6-5) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			2048,	/* Screen Stride  */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			75, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 16 (5-6-5) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			2048,	/* Screen Stride  */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			85, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 16 (5-6-5) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			2048,	/* Screen Stride  */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			90, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 16 (5-6-5) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			2048,	/* Screen Stride  */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			100, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			6,		/* Number Red bits */
			6,		/* Number Green bits */
			6,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 32 (8-8-8) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			4096,	/* Screen Stride  */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			60, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 32 (8-8-8) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			4096,	/* Screen Stride  */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			70, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 32 (8-8-8) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			4096,	/* Screen Stride  */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			72, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 32 (8-8-8) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			4096,	/* Screen Stride  */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			75, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 32 (8-8-8) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			4096,	/* Screen Stride  */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			85, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 32 (8-8-8) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			4096,	/* Screen Stride  */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			90, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x114,			/* Vesa mode number */
	   {
			sizeof(VIDEO_MODE_INFORMATION), 	/* 800 x 600 x 32 (8-8-8) */
			0,		/* ModeIndex */
			800,	/* Screen Width */
			600,	/* VisScreenHeight */
			4096,	/* Screen Stride  */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			100, 	/* Monitor frequency */
			400,	/* X millimeter */
			300,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			600,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x105,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 		/* 1024 x 768 x 8 */
			0,		/* ModeIndex */
			1024,	/* VisScreenWidth */
			768,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			60, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			768,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
	{
		0x105,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 		/* 1024 x 768 x 8 */
			0,		/* ModeIndex */
			1024,	/* VisScreenWidth */
			768,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			70, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			768,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
    {
		0x105,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 		/* 1024 x 768 x 8 */
			0,		/* ModeIndex */
			1024,	/* VisScreenWidth */
			768,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			72, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			768,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
	{
		0x105,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 		/* 1024 x 768 x 8 */
			0,		/* ModeIndex */
			1024,	/* VisScreenWidth */
			768,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			75, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			768,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
	{
		0x105,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 		/* 1024 x 768 x 8 */
			0,		/* ModeIndex */
			1024,	/* VisScreenWidth */
			768,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			85, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			768,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
    {
		0x105,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 		/* 1024 x 768 x 8 */
			0,		/* ModeIndex */
			1024,	/* VisScreenWidth */
			768,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			90, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			768,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
    {
		0x105,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 		/* 1024 x 768 x 8 */
			0,		/* ModeIndex */
			1024,	/* VisScreenWidth */
			768,	/* VisScreenHeight */
			1024,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			100, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			1024,	/* VideoMemoryBitmapWidth */
			768,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		},
	},
	{
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 16 (5-6-5) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			60, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 16 (5-6-5) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			70, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 16 (5-6-5) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			72, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 16 (5-6-5) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			75, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 16 (5-6-5) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			85, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 16 (5-6-5) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			90, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 16 (5-6-5) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			2048,	/* Screen Stride */
			1,		/* Number of planes */
			16, 	/* Bits per plane */
			100, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 32 (8-8-8) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			60, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFf<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 32 (8-8-8) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			70, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 32 (8-8-8) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			72, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFf<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 32 (8-8-8) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			75, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
	{
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 32 (8-8-8) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			85, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 32 (8-8-8) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			90, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
		0x117,			/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/*	1024 x 768 x 32 (8-8-8) */
			0,		/* ModeIndex */
			1024,	/* Screen Width */
			768,	/* VisScreenHeight */
			4096,	/* Screen Stride */
			1,		/* Number of planes */
			32, 	/* Bits per plane */
			100, 	/* Monitor frequency */
			512,	/* X millimeter */
			384,	/* Y millimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			1024,	/* Bitmap width */
			768,	/* Bitmap height */
			0		/* Driver specific attributes */
		},
	},
    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 8 
            0,          // ModeIndex 
            1152,       // VisScreenWidth 
            864,        // VisScreenHeight 
            2048,       // ScreenStride 
            1,          // NumberOfPlanes 
            8,          // BitsPerPlane 
            60,         // Frequency 
            512,        // XMillimeter 
            384,        // YMillimeter 
            8,          // NumberRedBits 
            8,          // NumberGreenBits 
            8,          // NumberBlueBits 
            0,          // RedMask 
            0,          // GreenMask 
            0,          // BlueMask 
                        // AttributeFlags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
                VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
            2048,       // VideoMemoryBitmapWidth 
            864,       // VideoMemoryBitmapHeight 
            0,          // DriverSpecificAttributeFlags 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 8 
            0,          // ModeIndex 
            1152,       // VisScreenWidth 
            864,        // VisScreenHeight 
            2048,       // ScreenStride 
            1,          // NumberOfPlanes 
            8,          // BitsPerPlane 
            70,         // Frequency 
            512,        // XMillimeter 
            384,        // YMillimeter 
            8,          // NumberRedBits 
            8,          // NumberGreenBits 
            8,          // NumberBlueBits 
            0,          // RedMask 
            0,          // GreenMask 
            0,          // BlueMask 
                        // AttributeFlags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
                VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
            2048,       // VideoMemoryBitmapWidth 
            864,       // VideoMemoryBitmapHeight 
            0,          // DriverSpecificAttributeFlags 
        },
    },
    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 8 
            0,          // ModeIndex 
            1152,       // VisScreenWidth 
            864,        // VisScreenHeight 
            2048,       // ScreenStride 
            1,          // NumberOfPlanes 
            8,          // BitsPerPlane 
            72,         // Frequency 
            512,        // XMillimeter 
            384,        // YMillimeter 
            8,          // NumberRedBits 
            8,          // NumberGreenBits 
            8,          // NumberBlueBits 
            0,          // RedMask 
            0,          // GreenMask 
            0,          // BlueMask 
                        // AttributeFlags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
                VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
            2048,       // VideoMemoryBitmapWidth 
            864,       // VideoMemoryBitmapHeight 
            0,          // DriverSpecificAttributeFlags 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 8 
            0,          // ModeIndex 
            1152,       // VisScreenWidth 
            864,        // VisScreenHeight 
            2048,       // ScreenStride 
            1,          // NumberOfPlanes 
            8,          // BitsPerPlane 
            75,         // Frequency 
            512,        // XMillimeter 
            384,        // YMillimeter 
            8,          // NumberRedBits 
            8,          // NumberGreenBits 
            8,          // NumberBlueBits 
            0,          // RedMask 
            0,          // GreenMask 
            0,          // BlueMask 
                        // AttributeFlags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
                VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
            2048,       // VideoMemoryBitmapWidth 
            864,       // VideoMemoryBitmapHeight 
            0,          // DriverSpecificAttributeFlags 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 8 
            0,          // ModeIndex 
            1152,       // VisScreenWidth 
            864,        // VisScreenHeight 
            2048,       // ScreenStride 
            1,          // NumberOfPlanes 
            8,          // BitsPerPlane 
            85,         // Frequency 
            512,        // XMillimeter 
            384,        // YMillimeter 
            8,          // NumberRedBits 
            8,          // NumberGreenBits 
            8,          // NumberBlueBits 
            0,          // RedMask 
            0,          // GreenMask 
            0,          // BlueMask 
                        // AttributeFlags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
                VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
            2048,       // VideoMemoryBitmapWidth 
            864,       // VideoMemoryBitmapHeight 
            0,          // DriverSpecificAttributeFlags 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 8 
            0,          // ModeIndex 
            1152,       // VisScreenWidth 
            864,        // VisScreenHeight 
            2048,       // ScreenStride 
            1,          // NumberOfPlanes 
            8,          // BitsPerPlane 
            90,         // Frequency 
            512,        // XMillimeter 
            384,        // YMillimeter 
            8,          // NumberRedBits 
            8,          // NumberGreenBits 
            8,          // NumberBlueBits 
            0,          // RedMask 
            0,          // GreenMask 
            0,          // BlueMask 
                        // AttributeFlags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
                VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
            2048,       // VideoMemoryBitmapWidth 
            864,       // VideoMemoryBitmapHeight 
            0,          // DriverSpecificAttributeFlags 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 8 
            0,          // ModeIndex 
            1152,       // VisScreenWidth 
            864,        // VisScreenHeight 
            2048,       // ScreenStride 
            1,          // NumberOfPlanes 
            8,          // BitsPerPlane 
            100,        // Frequency 
            512,        // XMillimeter 
            384,        // YMillimeter 
            8,          // NumberRedBits 
            8,          // NumberGreenBits 
            8,          // NumberBlueBits 
            0,          // RedMask 
            0,          // GreenMask 
            0,          // BlueMask 
                        // AttributeFlags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
                VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
            2048,       // VideoMemoryBitmapWidth 
            864,       // VideoMemoryBitmapHeight 
            0,          // DriverSpecificAttributeFlags 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 16 (5-6-5) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            4096,       // Screen Stride 
            1,          // Number of planes 
            16,         // Bits per plane 
            60,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            5,          // Number Red bits 
            6,          // Number Green bits 
            5,          // Number Blue bits 
            0x1f<<11,   // Red mask 
            0x3f<<5,    // Green mask 
            0x1f,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        }, 
    },
    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 16 (5-6-5) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            4096,       // Screen Stride 
            1,          // Number of planes 
            16,         // Bits per plane 
            70,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            5,          // Number Red bits 
            6,          // Number Green bits 
            5,          // Number Blue bits 
            0x1f<<11,   // Red mask 
            0x3f<<5,    // Green mask 
            0x1f,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        }, 
    },
    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 16 (5-6-5) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            4096,       // Screen Stride 
            1,          // Number of planes 
            16,         // Bits per plane 
            72,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            5,          // Number Red bits 
            6,          // Number Green bits 
            5,          // Number Blue bits 
            0x1f<<11,   // Red mask 
            0x3f<<5,    // Green mask 
            0x1f,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        }, 
    },
    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 16 (5-6-5) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            4096,       // Screen Stride 
            1,          // Number of planes 
            16,         // Bits per plane 
            75,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            5,          // Number Red bits 
            6,          // Number Green bits 
            5,          // Number Blue bits 
            0x1f<<11,   // Red mask 
            0x3f<<5,    // Green mask 
            0x1f,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        }, 
    },
    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 16 (5-6-5) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            4096,       // Screen Stride 
            1,          // Number of planes 
            16,         // Bits per plane 
            85,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            5,          // Number Red bits 
            6,          // Number Green bits 
            5,          // Number Blue bits 
            0x1f<<11,   // Red mask 
            0x3f<<5,    // Green mask 
            0x1f,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 16 (5-6-5) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            4096,       // Screen Stride 
            1,          // Number of planes 
            16,         // Bits per plane 
            90,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            5,          // Number Red bits 
            6,          // Number Green bits 
            5,          // Number Blue bits 
            0x1f<<11,   // Red mask 
            0x3f<<5,    // Green mask 
            0x1f,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 16 (5-6-5) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            4096,       // Screen Stride 
            1,          // Number of planes 
            16,         // Bits per plane 
            100,        // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            5,          // Number Red bits 
            6,          // Number Green bits 
            5,          // Number Blue bits 
            0x1f<<11,   // Red mask 
            0x3f<<5,    // Green mask 
            0x1f,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 32 (8-8-8) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            8192,       // Screen Stride 
            1,          // Number of planes 
            32,         // Bits per plane 
            60,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            8,          // Number Red bits 
            8,          // Number Green bits 
            8,          // Number Blue bits 
            0xFF<<16,   // Red mask 
            0xFF<<8,    // Green mask 
            0xFF,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 32 (8-8-8) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            8192,       // Screen Stride 
            1,          // Number of planes 
            32,         // Bits per plane 
            70,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            8,          // Number Red bits 
            8,          // Number Green bits 
            8,          // Number Blue bits 
            0xFF<<16,   // Red mask 
            0xFF<<8,    // Green mask 
            0xFF,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 32 (8-8-8) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            8192,       // Screen Stride 
            1,          // Number of planes 
            32,         // Bits per plane 
            72,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            8,          // Number Red bits 
            8,          // Number Green bits 
            8,          // Number Blue bits 
            0xFF<<16,   // Red mask 
            0xFF<<8,    // Green mask 
            0xFF,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 32 (8-8-8) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            8192,       // Screen Stride 
            1,          // Number of planes 
            32,         // Bits per plane 
            75,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            8,          // Number Red bits 
            8,          // Number Green bits 
            8,          // Number Blue bits 
            0xFF<<16,   // Red mask 
            0xFF<<8,    // Green mask 
            0xFF,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 32 (8-8-8) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            8192,       // Screen Stride 
            1,          // Number of planes 
            32,         // Bits per plane 
            85,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            8,          // Number Red bits 
            8,          // Number Green bits 
            8,          // Number Blue bits 
            0xFF<<16,   // Red mask 
            0xFF<<8,    // Green mask 
            0xFF,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },

    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 32 (8-8-8) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            8192,       // Screen Stride 
            1,          // Number of planes 
            32,         // Bits per plane 
            90,         // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            8,          // Number Red bits 
            8,          // Number Green bits 
            8,          // Number Blue bits 
            0xFF<<16,   // Red mask 
            0xFF<<8,    // Green mask 
            0xFF,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },
        
    {
        0x192,
        {
            sizeof(VIDEO_MODE_INFORMATION),         // 1152 x 864 x 32 (8-8-8) 
            0,          // ModeIndex 
            1152,       // Screen Width 
            864,        // VisScreenHeight 
            8192,       // Screen Stride 
            1,          // Number of planes 
            32,         // Bits per plane 
            100,        // Monitor frequency 
            512,        // X millimeter 
            384,        // Y millimeter 
            8,          // Number Red bits 
            8,          // Number Green bits 
            8,          // Number Blue bits 
            0xFF<<16,   // Red mask 
            0xFF<<8,    // Green mask 
            0xFF,       // Blue mask 
                        // Attribute flags 
            VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
            2048,       // Bitmap width 
            864,        // Bitmap height 
            0           // Driver specific attributes 
        },
    },
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 8 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			60, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 8 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			70, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 8 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			72, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 8 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			75, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 8 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			85, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 8 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			90, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 8 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			100, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 16 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			60, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 16 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			70, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 16 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			72, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 16 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			75, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 16 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			85, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 16 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			90, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 16 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			100, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 32 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			8192,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			32,		/* BitsPerPlane */
			60, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 32 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			8192,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			32,		/* BitsPerPlane */
			70, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 32 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			8192,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			32,		/* BitsPerPlane */
			72, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 32 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			8192,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			32,		/* BitsPerPlane */
			75, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 32 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			8192,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			32,		/* BitsPerPlane */
			85, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 32 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			8192,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			32,		/* BitsPerPlane */
			90, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x107,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1280 x 1024 x 32 */
			0,		/* ModeIndex */
			1280,	/* VisScreenWidth */
			1024,	/* VisScreenHeight */
			8192,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			32,		/* BitsPerPlane */
			100, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* Number Red bits */
			8,		/* Number Green bits */
			8,		/* Number Blue bits */
			0xFF<<16,	/* Red mask */
			0xFF<<8,	/* Green mask */
			0xFF,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1024,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 8 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			60, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 8 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			70, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 8 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			72, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 8 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			75, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 8 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			2048,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			8,		/* BitsPerPlane */
			85, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			8,		/* NumberRedBits */
			8,		/* NumberGreenBits */
			8,		/* NumberBlueBits */
			0,		/* RedMask */
			0,		/* GreenMask */
			0,		/* BlueMask */
					/* AttributeFlags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS |
				VIDEO_MODE_PALETTE_DRIVEN | VIDEO_MODE_MANAGED_PALETTE,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 16 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			60, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 16 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			70, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
    {
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 16 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			72, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 16 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			75, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
	{
		0x130,		/* Vesa mode number */
		{
			sizeof(VIDEO_MODE_INFORMATION), 	/* 1600 x 1200 x 16 */
			0,		/* ModeIndex */
			1600,	/* VisScreenWidth */
			1200,	/* VisScreenHeight */
			4096,	/* ScreenStride */
			1,		/* NumberOfPlanes */
			16,		/* BitsPerPlane */
			85, 	/* Frequency */
			512,	/* XMillimeter */
			384,	/* YMillimeter */
			5,		/* Number Red bits */
			6,		/* Number Green bits */
			5,		/* Number Blue bits */
			0x1f<<11,	/* Red mask */
			0x3f<<5,	/* Green mask */
			0x1f,		/* Blue mask */
					/* Attribute flags */
			VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS,
			2048,	/* VideoMemoryBitmapWidth */
			1200,	/* VideoMemoryBitmapHeight */
			0,		/* DriverSpecificAttributeFlags */
		}
	},
};

ULONG gxVideoModeCount = sizeof(gxVideoModes) / sizeof(GXVideoMode);
ULONG gxModeIndex = 0;

#define DRIVER_FLAG_LINEAR_MODE 0x80000000l
#define DRIVER_FLAG_COMPRESSION 0x40000000l