 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Miniport definitions.
  * </DOC_AMD_STD>
  * 
  */

#include "ntddvdeo.h"
#include "debug.h"

#define GX_CHIP_TYPE	L"GX2"
#define GX_DAC			L"Internal DAC"
#define GX_ADAPTER		L" Advanced Micro Devices"

#define HIBYTE(value)	(UCHAR) ((value & 0xff00) >> 8)
#define LOBYTE(value)	(UCHAR) ((value & 0xff))
#define HIWORD(value)	(USHORT) ((value & 0xffff0000) >> 16)
#define LOWORD(value)	(USHORT) ((value & 0xffff))

#define CURSOR_WIDTH	32
#define CURSOR_HEIGHT	32

/* The bits for DefaultSettings.Preferences in the registry */

typedef struct
{
    LONG    left;
    LONG    top;
    LONG    right;
    LONG    bottom;
} RECTL, *PRECTL;

/* SOFTVG VIRTUAL REGISTER DEFINITIONS */

#define VR_INDEX                0xAC1C
#define VR_DATA                 0xAC1E
#define VR_UNLOCK               0xFC53
#define VRC_VG                  0x0002         /* SoftVG Virtual Register Class    */
#define VG_MEM_SIZE             0x0000         /* MemSize Virtual Register         */
#define VG_FP_TYPE              0x0002         /* Flat Panel Info Virtual Register */
#define FP_DETECT_MASK          0x8000
#define FP_RESOLUTION_MASK      0x0038
#define FP_RES_640_480          0x0000
#define FP_RES_800_600          0x0008
#define FP_RES_1024_768         0x0010
#define FP_RES_1280_1024        0x0018

/* CS5535 DDC DEFINES */

#define DDC_DATA_OUT            0x0000
#define DDC_DATA_IN             0x0030
#define DDC_CLOCK_OUT           0x0000
#define DDC_CLOCK_IN            0x0030
#define DDC_OUT_ENABLE          0x0004
#define DDC_IN_ENABLE           0x0020
#define DDC_CLK_BIT             (1 << 3)
#define DDC_DATA_BIT            (1 << 4)
#define DDC_DATA_HIGH           DDC_DATA_BIT
#define DDC_DATA_LOW            (DDC_DATA_BIT << 16)
#define DDC_CLK_HIGH            DDC_CLK_BIT
#define DDC_CLK_LOW             (DDC_CLK_BIT << 16)

#define DDC_MODE_UNDEFINED      0
#define DDC_MODE_OUTPUT         1
#define DDC_MODE_INPUT          2

/* Global datatypes. */

/* HW_DEVICE_EXTENSION stores various private information about the driver.  It
 * is allocated and initialized in g91drv.c
 */

typedef struct _HW_DEVICE_EXTENSION 
{
	/* HARDWARE PHYSICAL ADDRESSES */
	/* Not all addresses will be filled in for all chips */

	PHYSICAL_ADDRESS PhysGXRegAddr;
	PHYSICAL_ADDRESS PhysGXSPAddr;
	PHYSICAL_ADDRESS PhysGXGPAddr;
	PHYSICAL_ADDRESS PhysGXVidAddr;
	PHYSICAL_ADDRESS PhysGXVIPAddr;
	PHYSICAL_ADDRESS PhysGXFBAddr;
	PHYSICAL_ADDRESS PhysGXVGAAddr;	
	
	/* REGION LENGTHS */

	ULONG       FBSize;
	PVOID		GXVGAAddr;			/* virtual address of vga space */

	ULONG		BitsPerPixel;		/* Current depth of the framebuffer */
	ULONG		ScreenWidth;		/* width of the screen*/
	ULONG		ScreenHeight;		/* height of the screen*/
	int			PanelWidth;			/* Video resolution of flat panel */
	int			PanelHeight;		/* may be smaller than displayed resolution */

	/* USER-CONFIGURABLE PARAMETERS */

	int			Compression;        /* Is Compression enabled in registry */
	int			DDCEnabled;         /* Is DDC check enabled in registry   */
	int			LinearFB;           /* Is a linear frame buffer enabled   */
	int         AntialiasedText;    /* Do we enable antialiased text?     */
	
	ULONG       ModeFlags;
 	ULONG		VRefreshRate;		/* vertical refresh rate */
	ULONG		CursorOffset;		/* Offset to cursor memory */
	ULONG       ScreenStride;

    ULONG       DDCBase;
    int         DDCClockMode;
    int         DDCDataMode;

#if _WIN32_WINNT >= 0x0500
	
	/* FOR DPMS */

	ULONG       CurrPowerState;   //the current power state for DPMS  
	ULONG		CurrDPMSVersion;  // the current DPMS version
	ULONG		CurrLength;
	ULONG       PreviousPowerState; //the Pervious power state for DPMS  

	// Save location for the graphics registers

	ULONG		savBitsPerPixel;		/* Current depth of the framebuffer */
	ULONG		savScreenWidth;		/* width of the screen*/
	ULONG		savScreenHeight;		/* height of the screen*/
	ULONG		savVRefreshRate;		/* vertical refresh rate */
		  //
    // pointers of VideoPort function that not available on NT4
    //

    PVOID     (*Win2kVideoPortGetRomImage)();
    PVOID     (*Win2kVideoPortGetCommonBuffer)();
    PVOID     (*Win2kVideoPortFreeCommonBuffer)();
    BOOLEAN   (*Win2kVideoPortDDCMonitorHelper)();
    LONG      (FASTCALL *Win2kVideoPortInterlockedExchange)();
    VP_STATUS (*Win2kVideoPortGetVgaStatus)();
#endif //_WIN32_WINNT >= 0x500

} HW_DEVICE_EXTENSION, *PHW_DEVICE_EXTENSION;

// definitions for the purpose of binary level compatable with NT4 
//

#if _WIN32_WINNT >= 0x0500

#define VideoPortGetRomImage \
        HwDeviceExtension->Win2kVideoPortGetRomImage

#define VideoPortGetCommonBuffer \
		HwDeviceExtension->Win2kVideoPortGetCommonBuffer

#define VideoPortFreeCommonBuffer \
        HwDeviceExtension->Win2kVideoPortFreeCommonBuffer

#define VideoPortDDCMonitorHelper \
        HwDeviceExtension->Win2kVideoPortDDCMonitorHelper

#define VideoPortInterlockedExchange \
        HwDeviceExtension->Win2kVideoPortInterlockedExchange

#define VideoPortGetVgaStatus \
        HwDeviceExtension->Win2kVideoPortGetVgaStatus

typedef LONG VP_STATUS;

#endif //_WIN32_WINNT >= 0x500

#define SIZE_NT4_VIDEO_PORT_CONFIG_INFO           0x42
#define SIZE_NT4_VIDEO_HW_INITIALIZATION_DATA     0x28


VP_STATUS GXSetDisplayMode(HW_DEVICE_EXTENSION *HwDeviceExtension,
		int display_mode);
VP_STATUS GXSetMode3(HW_DEVICE_EXTENSION *HwDeviceExtension);
ULONG GetOffscreenStart();
ULONG GetOffscreenEnd();
char *FindIoctl (ULONG code);

typedef struct
{
	ULONG vesaMode;
	VIDEO_MODE_INFORMATION	ntVideoMode;
} GXVideoMode;

#define WRITE_VGA_8(idx, data)	\
	VideoPortWritePortUchar((PUCHAR)HwDeviceExtension->GXVGAAddr + (idx) - VGA_FIRST, (data))

#define READ_VGA_8(idx)	\
	VideoPortReadPortUchar((PUCHAR)HwDeviceExtension->GXVGAAddr + (idx) - VGA_FIRST)

extern GXVideoMode gxVideoModes[];	/* List of all available modes */
extern ULONG gxVideoModeCount;		/* Number of entries in above list */
extern ULONG gxModeIndex;			/* Current mode */

extern unsigned char gfx_gxm_config_read(unsigned char index);

void WRITE_PORT_UCHAR(USHORT, UCHAR);
void WRITE_PORT_ULONG(USHORT, ULONG);
UCHAR READ_PORT_UCHAR(USHORT);
ULONG READ_PORT_ULONG(USHORT);

