 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Miniport driver routine definitions.
  * </DOC_AMD_STD>
  * 
  */

/* DRIVER ROUTINE DEFINITIONS */

VP_STATUS GXFindAdapter(HW_DEVICE_EXTENSION *HwDeviceExtension,
	VOID *HwContext, PWSTR ArgumentString, 
	PVIDEO_PORT_CONFIG_INFO ConfigInfo,
	UCHAR *Again);

BOOLEAN GXInitialize(HW_DEVICE_EXTENSION *HwDeviceExtension);

BOOLEAN GXStartIO(HW_DEVICE_EXTENSION *HwDeviceExtension,
	VIDEO_REQUEST_PACKET *RequestPacket);

BOOLEAN FilterUnsupportedModes(PHW_DEVICE_EXTENSION HwDeviceExtension);

void GXCursorOn(HW_DEVICE_EXTENSION *HwDeviceExtension);
void GXCursorOff(HW_DEVICE_EXTENSION *HwDeviceExtension);
void GXSetPalette(HW_DEVICE_EXTENSION *HwDeviceExtension,ULONG *pPal, ULONG StartIndex, ULONG Count);
int  GXMapPhysicalAddress (PVOID HwDeviceExtension, ULONG address, ULONG size, UCHAR IO, PULONG ptr_out);
VP_STATUS AddMappedAddressToArray (PHYSICAL_ADDRESS address, ULONG length, ULONG IO, 
								   PVOID array, PVOID HwDeviceExtension);

/* WIN2K/XP DPMS HELPER ROUTINES */

#if _WIN32_WINNT >= 0x0500
#ifdef WIN2K_DPMS

VP_STATUS GXGetPowerState(HW_DEVICE_EXTENSION *HwDeviceExtension, ULONG  HwId,
						  PVIDEO_POWER_MANAGEMENT  VideoPowerControl);

VP_STATUS GXSetPowerState(HW_DEVICE_EXTENSION *HwDeviceExtension, ULONG  HwId,
						  PVIDEO_POWER_MANAGEMENT  VideoPowerControl);
ULONG
GXGetChildDescriptor( 
    HW_DEVICE_EXTENSION *HwDeviceExtension, PVIDEO_CHILD_ENUM_INFO ChildEnumInfo,
    PVIDEO_CHILD_TYPE pChildType, PVOID pChildDescriptor, 
    PULONG pUId, PULONG pUnused );

#endif 
#endif 

#define ADD_TO_ACCESS_RANGES(counter, Base, Size, IO)     \
{                                                         \
	if (Base)                                             \
	{                                                     \
		accessRanges[counter].RangeStart.LowPart  = Base; \
		accessRanges[counter].RangeStart.HighPart = 0;    \
		accessRanges[counter].RangeLength         = Size; \
		accessRanges[counter].RangeInIoSpace      = IO;   \
		accessRanges[counter].RangeVisible        = 1;    \
		accessRanges[counter].RangeShareable      = 1;    \
		counter++;                                        \
	}                                                     \
}





