 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Debug Print support.
  * </DOC_AMD_STD>
  * 
  */

#if DBG

#include <devioctl.h>

#include <miniport.h>
#if _WIN32_WINNT >= 0x0500
#include "ntddvdeo.h"
#endif //_WIN32_WINNT >= 0x500
#include <video.h>
#include <stdio.h>
#include <stdarg.h>
#include "gxdrv.h"
#include "debug.h"

ULONG DebugLevel = 500;

unsigned long DbgPrint(char *,...);

/* DebugPrint
 *
 * Takes a debug level and a variable argument list.  The list is
 * formatted into a string.  The string is then either sent to
 * COM2 like traditional NT output, accumulated in a circular
 * buffer, both, or neither.
 */
void
DebugPrint(ULONG DebugPrintLevel, PCHAR DebugMessage, ...)
{
	va_list ap;

	va_start(ap, DebugMessage);

	if(DebugPrintLevel >= DebugLevel) {
		char buffer[256];
		char *outPtr;
		int  len;
		int prefixLen;

		outPtr = &buffer[0];	/* Pointer to beginning of output buffer */

		while(*DebugMessage == '\n')
			*outPtr++ = *DebugMessage++;

		/* We prepend the DBG_STRING to each string, and
		 * append a new-line character to the end:
		 */

		prefixLen = strlen(DBG_STRING);
		memcpy(outPtr, DBG_STRING, prefixLen);
		outPtr += prefixLen;

		len = vsprintf(outPtr, DebugMessage, ap);
		outPtr += len;

		if(outPtr[-1] != '\n')
			*outPtr++ = '\n';

		*outPtr = '\0';

		/* Send debug string out over COM2 */
		DbgPrint(buffer);
	}

	va_end(ap);
}

#endif /*DBG*/
