 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * DrvLineTo support.
  * </DOC_AMD_STD>
  * 
  */

#include "precomp.h"
#include "gfx_regs.h"
#include "gfx_defs.h"

#define GU2_WAIT_PENDING while(READ_GP32(MGP_BLT_STATUS) & MGP_BS_BLT_PENDING)
#define GU2_WAIT_BUSY while(READ_GP32(MGP_BLT_STATUS) & MGP_BS_BLT_BUSY)

extern unsigned char *gfx_virt_fbptr;
extern unsigned char *gfx_virt_gpptr;
extern unsigned long  gu2_bpp;
extern unsigned char  mode_shift;

/*-------------------------------------------------------------------------
 * DrvLineTo
 *
 * Draws a single solid integer-only cosmetic line.
 *-------------------------------------------------------------------------*/

BOOL DrvLineTo(
	SURFOBJ*	pso,
	CLIPOBJ*	pco,
	BRUSHOBJ*	pbo,
	LONG		x0,
	LONG		y0,
	LONG		x1,
	LONG		y1,
	RECTL*		prclBounds,
	MIX 		mix)
{
    PDEV *ppdev;
    ULONG   ROP;
    ULONG   VecMode;
    long dx, dy, dmaj, dmin;
	long axialerr, diagerr, initerr;
    ULONG   dstOffset, dstPitch;
    ULONG   index;
    BOOL    ret;

    ppdev = (PDEV *)pso->dhpdev;

    DISPDBG ((ppdev, 1, "DrvLineTo Entry\n"));

    ACQUIRE_PRIMITIVE_SEMAPHORE;

    // PUNT ALL BLTS DURING A MODECHANGE
    // In very rare cases, the mode can be changed before Windows has finished rendering
    // to all surfaces from the previous mode.  We will thus punt all rendering calls until
    // all such surfaces have been deleted.

    if (old_mode_count)
    {
        DISPDBG ((ppdev, 3000, "Punting DrvLineTo during modechange\n"));
        goto puntIt;
    }

    // EXTRACT DESTINATION OFFSET AND PITCH
    //
    index = dhsurf_array[(USHORT)pso->dhsurf];
    if (index & CACHE_FLAG_SYSTEM)
        goto puntIt;

    dstOffset = bitmap_heap[(USHORT)index].heap_offset;
    dstPitch  = bitmap_heap[(USHORT)index].flags_and_pitch;

    /* CALCULATE ROP AND DESTINATION REQUIRED */

    ROP = (ULONG)MixToRop[mix & 0xF];

    if ((ROP & 0x55) ^ ((ROP >> 1) & 0x55))
        VecMode = MGP_VM_DST_REQ;
    else
        VecMode = 0;

    if (pco == NULL || pco->iDComplexity  == DC_TRIVIAL)
    {
        dx = x1 - x0;
        if (dx < 0) dx = -dx;
        dy = y1 - y0;
        if (dy < 0) dy = -dy;

        if (dx >= dy)
        {
            dmaj = dx;
            dmin = dy;
            if (x1 > x0) VecMode |= 2;
            if (y1 > y0) VecMode |= 4;
        }
        else
        {
            dmaj = dy;
            dmin = dx;
            VecMode |= 1;
            if (x1 > x0) VecMode |= 4;
            if (y1 > y0) VecMode |= 2;
        }
        axialerr = dmin << 1;
        diagerr  = (dmin - dmaj) << 1;
        initerr  = (dmin << 1) - dmaj;
	    if (!(VecMode & 4)) initerr--;

        GU2_WAIT_PENDING;

        WRITE_GP32 (MGP_RASTER_MODE, gu2_bpp | ROP);
        WRITE_GP32 (MGP_PAT_COLOR_0, pbo->iSolidColor);
        WRITE_GP32 (MGP_STRIDE, dstPitch);
        WRITE_GP32 (MGP_DST_OFFSET, 
            (y0 * dstPitch) +
            (x0 << mode_shift) + 
            dstOffset);
	    WRITE_GP32 (MGP_VEC_ERR, (((unsigned long)axialerr) << 16) | (unsigned short)diagerr);
	    WRITE_GP32 (MGP_VEC_LEN, (((unsigned long)dmaj)     << 16) | (unsigned short)initerr);
	    WRITE_GP32 (MGP_VECTOR_MODE, VecMode);

        RELEASE_PRIMITIVE_SEMAPHORE;

        DISPDBG ((ppdev, 1, "DrvLineTo Exit\n"));
        return TRUE;
    }

puntIt:

    MAKE_PUNTABLE(pso);

    GU2_WAIT_BUSY;
    ret = EngLineTo (pso, pco, pbo, x0, y0, x1, y1, prclBounds, mix);

    RELEASE_PRIMITIVE_SEMAPHORE;

    return ret;

returnTrue:

    RELEASE_PRIMITIVE_SEMAPHORE;

    return TRUE;
}

