 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Video Memory Heap definitions.
  * </DOC_AMD_STD>
  * 
  */

#ifndef __GX_HEAP_H
#define __GX_HEAP_H

#include "precomp.h"

typedef struct _BITMAP_CACHE_ENTRY 
{
    HBITMAP surface_handle;
    HBITMAP punt_surface;
    SURFOBJ *lockedSurf;
	unsigned long dhsurf;
	unsigned long flags_and_pitch;
	unsigned long width_and_height;
	unsigned long bitmap_size;
    unsigned long heap_offset;

} BITMAP_CACHE_ENTRY;

void EmptyBitmapHeap (PDEV *ppdev, unsigned long new_heap_start);
void ResetDDrawHeap (void);
void ClearBitmapHeap(void);
void RepackCache();
int AddDDrawBitmap (PDEV *ppdev, unsigned long bitmap_size, unsigned long pitch);
void ResetDDrawHeap (void);
void SetPrimaryHeapEntry (PDEV *ppdev);
int AddLockedSurf (PDEV *ppdev, int index);
int AddLockedSurfForSystemBitmap (PDEV *ppdev, int index);

#define CACHE_FLAG_INVALID 0x10000
#define CACHE_FLAG_SYSTEM  0x20000

extern BITMAP_CACHE_ENTRY bitmap_heap[];
extern BITMAP_CACHE_ENTRY system_heap[];
extern unsigned long dhsurf_array[];

#endif