 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Display/miniport shared definitions.
  * </DOC_AMD_STD>
  * 
  */

#ifndef __GXINFO_H_JUNE_22_2000
#define __GXINFO_H_JUNE_22_2000

// If you are expanding this struct, add your field
// to the end of the struct, so it does not break
// any of the existing ioctl.
typedef struct _GX_VIDEO_MODE_INFORMATION
{
	VIDEO_MODE_INFORMATION modeInfo;
    ULONG   OffscreenStart;
    ULONG   OffscreenEnd;
} GX_VIDEO_MODE_INFORMATION, *PGX_VIDEO_MODE_INFORMATION;

typedef struct _DURANGO_FUNCS
{
    /* ROUTINES IN GFX_DISP.C */

    int (*pfn_is_display_mode_supported)(int xres, int yres, int bpp, int hz);
    int (*pfn_set_display_mode)(int xres, int yres, int bpp, int hz);
    int	(*pfn_set_display_timings)(unsigned short bpp, unsigned short flags,
	    unsigned short hactive, unsigned short hblank_start, 
	    unsigned short hsync_start, unsigned short hsync_end, 
	    unsigned short hblank_end, unsigned short htotal, 
        unsigned short vactive, unsigned short vblank_start, 
	    unsigned short vsync_start, unsigned short vsync_end, 
	    unsigned short vblank_end, unsigned short vtotal,
	    unsigned long frequency);
    void (*pfn_set_display_pitch)(unsigned short pitch);
    void (*pfn_set_display_offset)(unsigned long offset);
    int (*pfn_set_display_palette_entry)(unsigned long index, unsigned long palette);
    int (*pfn_set_display_palette)(unsigned long *palette);
    void (*pfn_set_clock_frequency)(unsigned long frequency);
    int (*pfn_set_crt_enable)(int enable);
    void (*pfn_set_cursor_enable)(int enable);
    void (*pfn_set_cursor_colors)(unsigned long bkcolor, unsigned long fgcolor);
    void (*pfn_set_cursor_position)(unsigned long memoffset, 
	    unsigned short xpos, unsigned short ypos, 
	    unsigned short xhotspot, unsigned short yhotspot);
    void (*pfn_set_cursor_shape32)(unsigned long memoffset, 
	    unsigned long *andmask, unsigned long *xormask);
    void (*pfn_set_cursor_shape64)(unsigned long memoffset, 
	    unsigned long *andmask, unsigned long *xormask);
    int (*pfn_set_compression_enable)(int enable);
    int (*pfn_set_compression_offset)(unsigned long offset);
    int (*pfn_set_compression_pitch)(unsigned short pitch);
    int (*pfn_set_compression_size)(unsigned short size);
    void (*pfn_set_display_priority_high)(int enable);
    int (*pfn_test_timing_active)(void);
    int (*pfn_test_vertical_active)(void);
    int (*pfn_wait_vertical_blank)(void);
    void (*pfn_delay_milliseconds)(unsigned long milliseconds);
    void (*pfn_delay_microseconds)(unsigned long microseconds);
    void (*pfn_enable_panning)(int x, int y);
    int (*pfn_set_fixed_timings)(int panelResX, int panelResY, unsigned short width, unsigned short height, unsigned short bpp);

    /* "READ" ROUTINES IN GFX_DISP.C */

    int (*pfn_get_display_details)(unsigned int mode, int *xres, int *yres, int *hz);
    unsigned short (*pfn_get_display_pitch)(void);
    int (*pfn_get_sync_polarities)(void);
    unsigned long (*pfn_get_clock_frequency)(void);
    unsigned long (*pfn_get_max_supported_pixel_clock )(void);
    int (*pfn_mode_frequency_supported)(int xres, int yres, int bpp, unsigned long frequency);
    int (*pfn_get_refreshrate_from_frequency)(int xres, int yres, int bpp, int *hz, unsigned long frequency);
    int (*pfn_get_display_mode_count)(void);
    int (*pfn_get_display_mode)(int *xres, int *yres, int *bpp, int *hz);
    unsigned short (*pfn_get_hactive)(void);
    unsigned short (*pfn_get_hblank_start)(void);
    unsigned short (*pfn_get_hsync_start)(void);
    unsigned short (*pfn_get_hsync_end)(void);
    unsigned short (*pfn_get_hblank_end)(void);
    unsigned short (*pfn_get_htotal)(void);
    unsigned short (*pfn_get_vactive)(void);
    unsigned short (*pfn_get_vline)(void);
    unsigned short (*pfn_get_vblank_start)(void);
    unsigned short (*pfn_get_vsync_start)(void);
    unsigned short (*pfn_get_vsync_end)(void);
    unsigned short (*pfn_get_vblank_end)(void);
    unsigned short (*pfn_get_vtotal)(void);
    unsigned short (*pfn_get_display_bpp)(void);
    unsigned long (*pfn_get_display_offset)(void);
    int (*pfn_get_display_palette_entry)(unsigned long index, unsigned long *palette);
    void (*pfn_get_display_palette)(unsigned long *palette);
    unsigned long (*pfn_get_cursor_enable)(void);
    unsigned long (*pfn_get_cursor_offset)(void);
    unsigned long (*pfn_get_cursor_position)(void);
    unsigned long (*pfn_get_cursor_clip)(void);
    unsigned long (*pfn_get_cursor_color)(int color);
    int (*pfn_get_compression_enable)(void);
    unsigned long (*pfn_get_compression_offset)(void);
    unsigned short (*pfn_get_compression_pitch)(void);
    unsigned short (*pfn_get_compression_size)(void);
    int (*pfn_get_display_priority_high)(void);
    int (*pfn_get_valid_bit)(int line);

    /* ROUTINES IN GFX_RNDR.C */

    void (*pfn_set_bpp)(unsigned short bpp);
    void (*pfn_set_solid_pattern)(unsigned long color);
    void (*pfn_set_mono_pattern)(unsigned long bgcolor, unsigned long fgcolor, 
	    unsigned long data0, unsigned long data1, unsigned char transparency);
    void (*pfn_set_color_pattern)(unsigned long bgcolor, unsigned long fgcolor, 
	    unsigned long data0, unsigned long data1,unsigned long data2,unsigned long data3, unsigned char transparency);
    void (*pfn_set_solid_source)(unsigned long color);
    void (*pfn_set_mono_source)(unsigned long bgcolor, unsigned long fgcolor,
	    unsigned short transparent);
    void (*pfn_set_raster_operation)(unsigned char rop);
    void (*pfn_pattern_fill)(unsigned short x, unsigned short y, 
	    unsigned short width, unsigned short height);
    void (*pfn_screen_to_screen_blt)(unsigned short srcx, unsigned short srcy,
	    unsigned short dstx, unsigned short dsty, unsigned short width, 
	    unsigned short height);
    void (*pfn_screen_to_screen_xblt)(unsigned short srcx, unsigned short srcy,
	    unsigned short dstx, unsigned short dsty, unsigned short width, 
	    unsigned short height, unsigned long color);
    void (*pfn_color_bitmap_to_screen_blt)(unsigned short srcx, unsigned short srcy,
	    unsigned short dstx, unsigned short dsty, unsigned short width, 
	    unsigned short height, unsigned char *data, long pitch); 
    void (*pfn_color_bitmap_to_screen_xblt)(unsigned short srcx, unsigned short srcy,
	    unsigned short dstx, unsigned short dsty, unsigned short width, 
	    unsigned short height, unsigned char *data, long pitch, 
	    unsigned long color); 
    void (*pfn_mono_bitmap_to_screen_blt)(unsigned short srcx, unsigned short srcy,
	    unsigned short dstx, unsigned short dsty, unsigned short width, 
	    unsigned short height, unsigned char *data, short pitch); 
    void (*pfn_text_blt)(unsigned short dstx, unsigned short dsty, 
	    unsigned short width, unsigned short height, unsigned char *data);
    void (*pfn_bresenham_line)(unsigned short x, unsigned short y, 
	    unsigned short length, unsigned short initerr, 
	    unsigned short axialerr, unsigned short diagerr, 
	    unsigned short flags);
    void (*pfn_wait_until_idle)(void);
    int (*pfn_test_blt_pending)(void);

    void (*pfn2_set_source_stride)(unsigned short stride);
    void (*pfn2_set_destination_stride)(unsigned short stride);
    void (*pfn2_set_pattern_origin)(int x, int y);
    void (*pfn2_set_source_transparency)(unsigned long color, unsigned long mask);
    void (*pfn2_set_alpha_mode)(int mode);
    void (*pfn2_set_alpha_value)(unsigned char value);
    void (*pfn2_pattern_fill)(unsigned long dstoffset, unsigned short width, 
	    unsigned short height);
    void (*pfn2_color_pattern_fill)(unsigned long dstoffset, unsigned short width, 
	    unsigned short height, unsigned long *pattern);
    void (*pfn2_screen_to_screen_blt)(unsigned long srcoffset, unsigned long dstoffset, 
	    unsigned short width, unsigned short height, int flags);
    void (*pfn2_mono_expand_blt)(unsigned long srcbase, unsigned short srcx, 
	    unsigned short srcy, unsigned long dstoffset, unsigned short width, 
	    unsigned short height, int byte_packed);
    void (*pfn2_color_bitmap_to_screen_blt)(unsigned short srcx, unsigned short srcy,
	    unsigned long dstoffset, unsigned short width, unsigned short height, 
	    unsigned char *data, short pitch);
    void (*pfn2_mono_bitmap_to_screen_blt)(unsigned short srcx, unsigned short srcy,
	    unsigned long dstoffset, unsigned short width, unsigned short height, 
	    unsigned char *data, short pitch);
    void (*pfn2_text_blt)(unsigned long dstoffset, unsigned short width, unsigned short height, 
					    unsigned char *data);
    void (*pfn2_bresenham_line)(unsigned long dstoffset, 
	    unsigned short length, unsigned short initerr, 
	    unsigned short axialerr, unsigned short diagerr, 
	    unsigned short flags);

    /* ROUTINES IN GFX_VID.C */

    int (*pfn_set_video_enable)(int enable);
    int (*pfn_set_video_format)(unsigned long format);
    int (*pfn_set_video_size)(unsigned short width, unsigned short height);
    int (*pfn_set_video_offset)(unsigned long offset);
    int (*pfn_set_video_yuv_pitch)(unsigned long ypitch, unsigned long uvpitch);
    int (*pfn_set_video_yuv_offsets)(unsigned long yoffset, unsigned long uoffset, unsigned long voffset);
    int (*pfn_set_video_window)(short x, short y, unsigned short w, 
	    unsigned short h);
    int (*pfn_set_video_left_crop)(unsigned short x);
    int (*pfn_set_video_scale)(unsigned short srcw, unsigned short srch, 
	    unsigned short dstw, unsigned short dsth);
    int (*pfn_set_video_downscale_config)(unsigned short type, unsigned short m); 
    int (*pfn_set_video_color_key)(unsigned long key, unsigned long mask, 
	    int bluescreen);
    int (*pfn_set_video_filter)(int xfilter, int yfilter);
    int (*pfn_set_video_palette)(unsigned long *palette);
    int (*pfn_set_graphics_palette_entry)(unsigned long index, unsigned long palette);
    int (*pfn_set_video_downscale_coefficients)(unsigned short coef1, unsigned short coef2,
										    unsigned short coef3, unsigned short coef4) ;
    int (*pfn_set_video_downscale_enable)(int enable);										 
    int (*pfn_set_video_cursor)(unsigned long key, unsigned long mask, unsigned short select_color2,
						    unsigned long color1, unsigned long color2);
    int (*pfn_set_video_request)(short x, short y);

    int (*pfn_select_alpha_region)(int region);
    int (*pfn_set_alpha_enable)(int enable);
    int (*pfn_set_alpha_window)(short x, short y, 
	    unsigned short width, unsigned short height);
    int (*pfn_set_alpha_value)(unsigned char alpha, char delta);
    int (*pfn_set_alpha_priority)(int priority);
    int (*pfn_set_alpha_color)(unsigned long color);
    int (*pfn_set_no_ck_outside_alpha)(int enable);
    int (*pfn_set_macrovision_enable)(int enable);
    unsigned long (*pfn_detect_cpu)(void);
    unsigned long (*pfn_get_cpu_register_base)(void);
    unsigned long (*pfn_get_frame_buffer_base)(void);
    unsigned long (*pfn_get_frame_buffer_size)(void);
    unsigned long (*pfn_get_vid_register_base)(void);
    unsigned long (*pfn_get_vip_register_base)(void);

    /* SYSTEM SETTINGS */
    /* The following are a mix of user and system settings that */
    /* determine how memory is arranged.                        */

    unsigned long CursorOffset;
    int LinearFB;
    int AntialiasedText;

    /* PANEL VARIABLES */

    unsigned short *pPanelWidth;
    unsigned short *pPanelHeight;
    unsigned short *pPanelEnable;

    int *pDeltaX;
    int *pDeltaY;

} DURANGO_FUNCS, *PDURANGO_FUNCS;

#define VIDEO_CUSTOMER_BASE 0x800
#define IOFN_GETGXINFO      (VIDEO_CUSTOMER_BASE + 1)
#define IOFN_GETDURANGO_FUNCS      (VIDEO_CUSTOMER_BASE + 100)
#define IOFN_SET_HEAP_INFORMATION      (VIDEO_CUSTOMER_BASE + 101)

#define IOCTL_GET_GX_INFO\
      CTL_CODE(FILE_DEVICE_VIDEO, IOFN_GETGXINFO, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_GET_DURANGO_FUNCS\
      CTL_CODE(FILE_DEVICE_VIDEO, IOFN_GETDURANGO_FUNCS, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_SET_HEAP_INFORMATION\
    CTL_CODE(FILE_DEVICE_VIDEO, IOFN_SET_HEAP_INFORMATION, METHOD_BUFFERED, FILE_ANY_ACCESS)

#endif
