 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * GX Access macros and definitions.
  * </DOC_AMD_STD>
  * 
  */

/* ALU modes for GP_RASTER_MODE register. */

#define GX_BLACKNESS		0x00000			/* Set destination to black */
#define GX_DSTINVERT		0x00055			/* Reverse bits in destination */
#define GX_SRCCOPY			0x000CC			/* Copy source to destination */
#define GX_PATCOPY			0x000F0			/* Copy pattern to destination */
#define GX_WHITENESS		0x000FF			/* Set destination to white */

/* Blit values for the GP_VECTOR_MODE register */

#define GP_VECTOR_DEST_DATA 		0x8 	/* Destination data required */
#define GP_VECTOR_MINOR_AXIS_POS	0x4 	/* positive minor axis increment */
#define GP_VECTOR_MINOR_AXIS_NEG	0x0 	/* negative minor axis increment */
#define GP_VECTOR_MAJOR_AXIS_POS	0x2 	/* positive major axis increment */
#define GP_VECTOR_MAJOR_AXIS_NEG	0x0 	/* negative major axis increment */
#define GP_VECTOR_Y_MAJOR			0x1 	/* y-major axis vector */
#define GP_VECTOR_X_MAJOR			0x0 	/* x-major axis vector */

#define MEM_READ_REG32(regptr, regoffset) \
	(*(volatile unsigned long *)((unsigned long)regptr + regoffset))

/* BLT MACROS */

#define WAIT_BLIT_ENGINE	{while(ppdev->myfuncs.pfn_test_blt_pending()) ; }
#define BLIT_ENGINE_BUSY (ppdev->myfuncs.pfn_test_blt_pending())
#define WAIT_BLIT_BUFFER	(ppdev->myfuncs.pfn_wait_until_idle())
#define BLIT_BUFFER_BUSY	\
	(MEM_READ_REG32 (gfx_virt_gpptr, MGP_BLT_STATUS) & MGP_BS_BLT_BUSY)  



