 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * GX Support routines.
  * </DOC_AMD_STD>
  * 
  */

#include "precomp.h"

/* Table to convert ROP2s to ROP3s */
USHORT
MixToRop[] = {
	0xff,	/* 1 - Used by paint routines */
	0,		/* 0 */
	0x05,	/* DPon */
	0x0a,	/* DPna */
	0x0f,	/* Pn */
	0x50,	/* PDna */
	0x55,	/* Dn */
	0x5a,	/* DPx */
	0x5f,	/* DPan */
	0xa0,	/* DPa */
	0xa5,	/* DPxn */
	0xaa,	/* D */
	0xaf,	/* DPno */
	0xf0,	/* P */
	0xf5,	/* PDno */
	0xfa,	/* DPo */
	0xff,	/* 1 */
};


/* FindIntersection will return TRUE and the intersection in rectResult
 * if the rect1 and rect2 intersect.  Otherwise, it will return false
 * and rectResult is undefined. The input rectangles are assumed to be
 * well-ordered with (left < right) and (top < bottom).
 */


BOOL
FindIntersection(RECTL *rect0, RECTL *rect1, RECTL *rectResult)
{
	rectResult->left = MAX(rect0->left,  rect1->left);
	rectResult->right = MIN(rect0->right, rect1->right);

	if(rectResult->right > rectResult->left) {
		rectResult->top = MAX(rect0->top, rect1->top);
		rectResult->bottom = MIN(rect0->bottom, rect1->bottom);

		if(rectResult->bottom > rectResult->top) {
			return(TRUE);
		}
	}

	return(FALSE);
}

BOOL IntersectThreeWay (RECTL *rect0, RECTL *rect1, RECTL *rect2, RECTL *rectOut)
{
	LONG left, right, top, bottom;

	/* INTERSECT X AXIS */

	left  = MAX (rect0->left,  rect1->left);
	right = MIN (rect0->right, rect1->right);

	if (right <= left) return FALSE;

	left  = MAX (left,  rect2->left);
	right = MIN (right, rect2->right);

	if (right <= left) return FALSE;

	/* INTERSECT Y AXIS */

	top    = MAX (rect0->top,    rect1->top);
	bottom = MIN (rect0->bottom, rect1->bottom);

	if (bottom <= top) return FALSE;

	top    = MAX (top,    rect2->top);
	bottom = MIN (bottom, rect2->bottom);

	if (bottom <= top) return FALSE;
	
	rectOut->left   = left;
	rectOut->right  = right;
	rectOut->top    = top;
	rectOut->bottom = bottom;

	return TRUE;
}
