 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Driver escape definitions.
  * </DOC_AMD_STD>
  * 
  */

//Registry structure and defines for set/get
#define DISPPERF_EXTESC_GETPARAM           0x400 //1024
#define DISPPERF_EXTESC_SETPARAM           0x401

#define GFX_CPU_SC1200		2
#define	REG_COMPRESSION		0x01
#define	REG_DDCENABLED		0x02
#define REG_FBLINEAR        0x04
#define REG_ANTIALIASED     0x08
#define REG_ALL				0xFF


#define FILE_DEVICE_GEODE 53334
#define BLOCK_SIZE 512

#define IOCTL_SET_REGISTRY_PARAM  CTL_CODE(FILE_DEVICE_GEODE,2048,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_GET_REGISTRY_PARAM  CTL_CODE(FILE_DEVICE_GEODE,2049,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define GX2_SECRET_WORD     0xABAD00D

typedef struct _RegistryData
{
    ULONG Flag;
	ULONG Compression;
	ULONG DDCEnabled;
	ULONG FBLinear;
	ULONG AntialiasedText;
}RegistryData;

typedef struct _RegisterInfo
{
    ULONG Offset;
	ULONG Value;
}RegisterInfo;

//packet id for ReadReg

typedef struct _GeodeInformation{
	unsigned long FBBase;
	unsigned long GPBase;
	unsigned long DPBase;
	unsigned long VIPBase;
	unsigned long VIDBase;
	unsigned long FBSize;
	unsigned long Revision;
}GInfo;

typedef struct _GFX_READFB {
	unsigned int Offset;
	unsigned int size;
	unsigned char cbuf[2048];
}GFX_ReadFB;
