 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Driver Escape routines.
  * </DOC_AMD_STD>
  * 
  */
#include "precomp.h"
#include "escape.h"

extern unsigned char *gfx_virt_fbptr;

#ifdef DBG
	extern unsigned long BlendProfile[];
#endif

/*
 * ULONG DrvEscape(SURFOBJ *, ULONG, ULONG, VOID *, ULONG cjOut, VOID *pvOut)
 *
 * Driver escape entry point.  This function should return TRUE for any
 * supported escapes in response to QUERYESCSUPPORT, and FALSE for any
 * others.  All supported escapes are called from this routine.
 */

ULONG
DrvEscape(
	SURFOBJ*	pso,
	ULONG		iEsc,
	ULONG		cjIn,
	VOID*		pvIn,
	ULONG		cjOut,
	VOID*		pvOut)
{
	PDEV*	ppdev = NULL;
	ULONG	iQuery;
	LONG	lRet;
	DWORD ReturnedDataLength;

	ppdev = (PDEV*) pso->dhpdev;

	DISPDBG ((ppdev, 1, "DrvEscape\n"));
	lRet = 0;  // Assume failure, or not suported

	switch (iEsc)
	{
		case QUERYESCSUPPORT:
			
            // Note:  we don't need to check cjIn for this case since
			// NT's GDI validates this for use.

			iQuery = *(ULONG *)pvIn;

			switch (iQuery)
			{
				case DISPPERF_EXTESC_GETPARAM:
				case DISPPERF_EXTESC_SETPARAM:
				
					lRet = TRUE;
					break;
			}
			break;

		case DISPPERF_EXTESC_GETPARAM :

            // VERIFY THAT THE SIZE IS RIGHT
            // 
            if (cjIn  == (sizeof (RegistryData) + 8) &&
                cjOut == (sizeof (RegistryData) + 8))
            {
                // CHECK FOR SECRET APPLICATION KEYWORD
                //
                if (*(unsigned long *)pvIn == GX2_SECRET_WORD)
                {
                    if (EngDeviceIoControl(ppdev->hDriver, IOCTL_GET_REGISTRY_PARAM,
				        (PVOID)((ULONG)pvIn + 8), cjIn - 8, (PVOID)((ULONG)pvOut + 8), cjOut - 8, &ReturnedDataLength)) 
			        {
				        DISPDBG((ppdev, 99999, "Registry reading failed\n"));
				        break;
			        }

                    lRet = TRUE;
                }
            }
			break;
			
		case DISPPERF_EXTESC_SETPARAM :

			// VERIFY THAT THE SIZE IS RIGHT
            // 
            if (cjIn  == (sizeof (RegistryData) + 8) &&
                cjOut == (sizeof (RegistryData) + 8))
            {
                // CHECK FOR SECRET APPLICATION KEYWORD
                //
                if (*(unsigned long *)pvIn == GX2_SECRET_WORD)
                {
                    if (EngDeviceIoControl(ppdev->hDriver, IOCTL_SET_REGISTRY_PARAM,
				        (PVOID)((ULONG)pvIn + 8), cjIn - 8, (PVOID)((ULONG)pvOut + 8), cjOut - 8, &ReturnedDataLength)) 
			        {
				        DISPDBG((ppdev, 99999, "Registry writing failed\n"));
				        break;
			        }

                    lRet = TRUE;
                }
            }
			break;
	}

	return ((ULONG) lRet);
}
