 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Display Driver Prototypes.
  * </DOC_AMD_STD>
  * 
  */

#ifndef MAX
#define MAX(a,b)	(((a) >= (b)) ? (a) : (b))
#endif /*MAX*/

#ifndef MIN
#define MIN(a,b)	(((a) <= (b)) ? (a) : (b))
#endif /*MIN*/

typedef unsigned long	uint32;
typedef unsigned short	uint16;
typedef unsigned char	uint8;

// CRUDE SEMAPHORE
// The following macros are used to prevent re-entrant or multithreaded code from executing
// two routines that touch the GP at once.
//
extern unsigned char *gfx_virt_regptr;

#define ACQUIRE_PRIMITIVE_SEMAPHORE                     \
{                                                       \
    while (*(volatile unsigned long *)(&g_blt))         \
        WRITE_REG32 (DC3_UNLOCK, DC3_UNLOCK_VALUE);     \
    g_blt = 1;                                          \
}
#define RELEASE_PRIMITIVE_SEMAPHORE   { g_blt = 0; }

/* Put all the conditional-compile constants here.	There had better
 * not be many!
 */

/* Size of circular log for debugging output */
#define DEBUG_LOG_SIZE			0x50000

#define DEBUG_MODE_NT			0x001		/* Direct debugging to cable */
#define DEBUG_MODE_LOG			0x002		/* Direct debugging to log */

/* Miscellaneous shared stuff */

#define DLL_NAME				L"gx"		/* Name of the DLL in UNICODE */
#define STANDARD_DEBUG_PREFIX	"VDD: " 	/* All debug output is prefixed */
											/*	 by this string */

/* Size of the DriverExtra information in the DEVMODE structure*/
#define DRIVER_EXTRA_SIZE	0

/* On non-alpha systems, we don't have to
 * worry about the chip caching our bus writes.
 */
#define XFER_BUFFERS	1

#define XFER_MASK			(XFER_BUFFERS - 1)

#define CLIP_LIMIT			50	/* We'll be taking 800 bytes of stack space */

typedef struct _CLIPENUM {
	LONG	c;
	RECTL	arcl[CLIP_LIMIT];	/* Space for enumerating complex clipping */
} CLIPENUM;

typedef struct _PDEV PDEV;		/* Handy forward declaration */

/* Dither stuff */

/* Describes a single color tetrahedron vertex for dithering: */

typedef struct _VERTEX_DATA {
	ULONG ulCount;				/* Number of pixels in this vertex */
	ULONG ulVertex; 			/* Vertex number */
} VERTEX_DATA;

VERTEX_DATA*	vComputeSubspaces(ULONG, VERTEX_DATA*);
VOID			vDitherColor(ULONG*, VERTEX_DATA*, VERTEX_DATA*, ULONG);

BOOL bEnablePointer(PDEV*);
VOID vDisablePointer(PDEV*);
VOID vAssertModePointer(PDEV*, BOOL);

#include "gxinfo.h" //SAS

/* Palette stuff */

BOOL bEnablePalette(PDEV*);
VOID vDisablePalette(PDEV*);

BOOL bInitializePalette(PDEV*, DEVINFO*);
VOID vUninitializePalette(PDEV*);

#define ROUND_UP_TO_64K(x)  (((ULONG)(x) + 0x10000 - 1) & ~(0x10000 - 1))

#define GX_ROP_PAT 1
#define GX_ROP_SRC 2
#define GX_ROP_DST 4

typedef struct _FLIPRECORD
{
    DWORD       fpFlipFrom;             // Surface we last flipped from
    BOOL        bFlipFlag;              // True if we think a flip is
                                        //   still pending
} FLIPRECORD;

/*
** VPE specific data
*/
typedef struct tagVPEDATA {
    BYTE        bInputWidthPixelAlign;
    BYTE        bFlags;
    BYTE        GUIDIndex;
    DWORD       dwBaseOffset;
    DWORD       *HDecimationTable;
    DWORD       *VDecimationTable;
    WORD        HDecimationSteps;
    WORD        VDecimationSteps;
    DWORD       dwVDecimationPattern;   // the current VDecimation pattern
    DWORD       dwNumBuffers;           // number of attached, flippable buffers
    DWORD       dwBufferSize;           // size of buffers in KB
    FLATPTR     fpCurrentSurface;
    //DDVIDEOPORTCAPS ddVideoPortCaps;    // the capabilities of this instance
} VPEDATA;

VPEDATA VPEData;

#define MAX_CLUT_SIZE (sizeof(VIDEO_CLUT) + (sizeof(ULONG) * 256))

/* The Physical Device data structure */

#define MAX_GX2_CURSOR_WIDTH  64
#define MAX_GX2_CURSOR_HEIGHT 64

typedef struct	_PDEV
{
	LONG		lDelta; 				// Distance from one scan to the next.
	LONG		cPelSize;				// 0 if 8bpp, 1 if 16bpp, 2 if 32bpp
	ULONG		iBitmapFormat;			// BMF_8BPP or BMF_16BPP or BMF_32BPP
										//	 (our current colour depth)

	// Rendering extensions colour information.

	UCHAR		rDepth; 				// Number of red bits
	UCHAR		gDepth; 				// Number of green bits
	UCHAR		bDepth; 				// Number of blue bits
	UCHAR		aDepth; 				// Number of alpha bits
	UCHAR		rBitShift;				// Left bit-shift for red component
	UCHAR		gBitShift;				// Left bit-shift for green component
	UCHAR		bBitShift;				// Left bit-shift for blue component
	UCHAR		aBitShift;				// Left bit-shift for alpha component

	// -------------------------------------------------------------------
	// NOTE: Changes up to here in the PDEV structure must be reflected in
	// i386\strucs.inc (assuming you're on an x86, of course)!

	HANDLE		hDriver;				// Handle to \Device\Screen
	HDEV		hdevEng;				// Engine's handle to PDEV
	HSURF		hsurfScreen;			// Engine's handle to screen surface
	SURFOBJ*	pdsurfScreen;			// Our private DSURF for the screen

	LONG		cxScreen;				// Visible screen width
	LONG		cyScreen;				// Visible screen height
	LONG		cxMemory;				// Width of Video RAM
	LONG		cyMemory;				// Height of Video RAM
	LONG		cBitsPerPel;			// Bits per pel (8, 15, 16, 24 or 32)
	LONG		refreshRate;			// Vertical refresh rate of the screen
	ULONG		ulMode; 				// Mode the mini-port driver is in.

	FLONG		flHooks;				// What we're hooking from GDI
	ULONG		ulWhite;				// 0xff if 8bpp, 0xffff if 16bpp,
										//	 0xffffffff if 32bpp

	////////// Palette stuff:

	PALETTEENTRY* pPal; 				// The palette if palette managed
	HPALETTE	hpalDefault;			// GDI handle to the default palette.
	FLONG		flRed;					// Red mask for 16/32bpp bitfields
	FLONG		flGreen;				// Green mask for 16/32bpp bitfields
	FLONG		flBlue; 				// Blue mask for 16/32bpp bitfields
	ULONG		cPaletteShift;			// number of bits the 8-8-8 palette must
										// be shifted by to fit in the hardware
										// palette.

	/* Brush stuff: */

	LONG		cPatterns;				// Count of bitmap patterns created
	HBITMAP 	ahbmPat[HS_DDI_MAX];	// Engine handles to standard patterns


	RECTL	scrnBounds; 		/* Dimensions of screen */

	ULONG RasterValue;			/* Holds value to be loaded into
								 * the GX's RASTER_MODE register.
								 */
	BOOL destMatters;			/* TRUE if GX needs to read dest data */
	SURFOBJ *pLockedSurf;
    SURFOBJ *pSurfObj;			/* Pointer to device surface */
	HBITMAP GXBitmap; 			/* Bitmap for GX surface */
	HSURF hsurf;				/* Device manageds surface */
	USHORT SrcColors[2];		/* Foreground and background colors */
	USHORT PatColors[4];		/* Stores pattern colors */
	ULONG PatData[4];			/* Pattern data */
	ULONG BytesPerPixel;		/* 1 or 8-bit, 2 for 16-bit framebuffer */
	volatile UCHAR *GXVga;		/* I/O mapped GX VGA space, starts at 0x3c0 */
	BOOL  cursorEnabled;			/* TRUE if cursor is on */
    BOOL  bSimulatedCursor;
	SHORT xHotSpot;				/* Cursor hotspot */
	SHORT yHotSpot;

	/* VIDEO STUFF */

	unsigned long video_offset;
	unsigned long video_buffer_offset;
	unsigned long video_buffer_uv_offset;
	unsigned long video_src_width;
	unsigned long video_src_height;
	unsigned long video_dst_width;
	unsigned long video_dst_height;
	unsigned long clippedSrcLines;
	unsigned long xcrop;
	
	long video_x;
	long video_y;

	BOOL compressionEnabled;   /* COMPRESSION FLAG */

	FLIPRECORD VideoFlipRecord;		/* Keeps track of ddraw surfaces */
	FLIPRECORD GraphicsFlipRecord;		/* Keeps track of ddraw surfaces */
	BOOL OverlayActive;			/* We only allow one overlay surface at a time */
	FLATPTR VisibleOverlay;		/* Pointer to visible overlay */
	USHORT	AuxID;				/* Value indicating IO chip type (Grappa/Cognac) */
	USHORT	CPUID;				/* Value indicating CPU chip type (gx, gxi, gxm) */
	USHORT	CPUSpeed;			/* Speed in MHz of CPU */
	//VIP Stuff
	VPEDATA	VPE;
	
#ifndef DURANGO
	ULONG hTiming;				/* Timing values for video overlays */
	ULONG vTiming;
#endif //DURANGO
#ifdef DBG
	UCHAR debugLog[DEBUG_LOG_SIZE]; /* Debugging log */
	ULONG debugBegin;			/* Index of begining of circular log */
	ULONG debugEnd; 			/* Index of end of circular log */
	ULONG debugMode;			/* Output of debugging to log, COM2, or both */
#endif /*DBG*/
	DURANGO_FUNCS myfuncs;		/* durango func pointers -SAS*/ 
} PDEV;

BOOL FindIntersection(RECTL *rect1, RECTL *rect2, RECTL *rectResult);
BOOL IntersectThreeWay (RECTL *rect0, RECTL *rect1, RECTL *rect2, RECTL *rectOut);
BOOL bInitializeModeFields(PDEV*, GDIINFO*, DEVINFO*, DEVMODEW*);

BOOL bEnableHardware(PDEV*);
VOID vDisableHardware(PDEV*);
BOOL bAssertModeHardware(PDEV*, BOOL);

BOOL bEnableGamma(PDEV*);

BOOL bInitializePatterns(PDEV*, INT);
VOID vUninitializePatterns(PDEV*);

extern USHORT MixToRop[];


/* Brush Structure and related definitions */

typedef struct {
	ULONG nSize;				/* size of this struct + pattern + mask */
	ULONG iPatternID;			/* ??? */
	ULONG flags;					/* accel flag */
	ULONG iType;				/* device or bitmap */
	ULONG iBitmapFormat;		/* 1 or 8 bpp */
	ULONG Color0; 				/* */
	ULONG Color1; 				/* */
	ULONG Color2; 				/* */
	ULONG Color3; 				/* */
	SIZEL sizlPattern;			/* xy dim in pixels & row */
	LONG lDeltaPattern; 		/* row pitch (signed) */
	SIZEL sizlMask; 			/* xy dim of mask */
	LONG lDeltaMask;			/* row pitch of mask */
	BYTE Pattern[1];			/* pattern itself */
	BYTE Mask[1]; 			/* mask itself */
} PBRUSH;

typedef PBRUSH *PPBRUSH;
#define PBRUSH_MASK 0x01
#define PBRUSH_2COLOR 0x02

extern ULONG gAllocTag;

/*Glabal variable for VIP*/
BYTE	GUIDIndex;

// PUNT MACRO
//
#define MAKE_PUNTABLE(surf)                                                  \
{                                                                            \
    ULONG index = dhsurf_array[(USHORT)surf->dhsurf];                        \
    if (!(index & CACHE_FLAG_SYSTEM))                                        \
    {                                                                        \
        index &= 0xFFFF;                                                     \
        if (!bitmap_heap[index].lockedSurf)                                  \
        {                                                                    \
            if (!AddLockedSurf (ppdev, index))                               \
                goto returnTrue;                                             \
        }                                                                    \
        surf = bitmap_heap[index].lockedSurf;                                \
    }                                                                        \
    else                                                                     \
    {                                                                        \
        index &= 0xFFFF;                                                     \
        if (!system_heap[index].lockedSurf)                                  \
        {                                                                    \
            if (!AddLockedSurfForSystemBitmap (ppdev, index))                \
                goto returnTrue;                                             \
        }                                                                    \
        surf = system_heap[index].lockedSurf;                                \
    }                                                                        \
}

// DRIVER MEMORY ALLOCATION
// This macro hardcodes calls to EngAllocMem with our heap ID, 'Dgx '
//
#define GX_ALLOC_MEM(flags, size)  EngAllocMem((flags), (size), 0x20786744)

#ifdef INCLUDE_DRIVER_GLOBALS
#define DRIVER_GLOBAL 
#else
#define DRIVER_GLOBAL  extern
#endif

DRIVER_GLOBAL unsigned long screen_width;
DRIVER_GLOBAL unsigned long screen_height;
DRIVER_GLOBAL unsigned long compression_enabled;
DRIVER_GLOBAL unsigned long heap_offset;
DRIVER_GLOBAL unsigned long heap_start;
DRIVER_GLOBAL unsigned long heap_end;
DRIVER_GLOBAL unsigned long ddraw_offset;
DRIVER_GLOBAL unsigned long mode_pitch;
DRIVER_GLOBAL unsigned long exclusive_mode;
DRIVER_GLOBAL unsigned long exclusive_set;
DRIVER_GLOBAL HDEV global_hdevEng;
DRIVER_GLOBAL long old_mode_count;
DRIVER_GLOBAL int g_blt;
