 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Debug out support
  * </DOC_AMD_STD>
  * 
  */

#include "precomp.h"

#if DBG

ULONG DebugLevel = 800;

extern long vsprintf(UCHAR *str, UCHAR *format, ...);
extern long sprintf(UCHAR *str, UCHAR *format, ...);

/////////////////////////////////////////////////////////////////////////
// DebugPrint
//
// DebugPrint takes a debug level and a variable argument list.  The list is
// formatted into a string.  The string is then either sent to
// COM2 like traditional NT output, accumulated in a circular
// buffer, both, or neither.
//
void DebugPrint(PDEV *ppdev, ULONG DebugPrintLevel, PCHAR DebugMessage, ...)
{
	va_list ap;

	va_start(ap, DebugMessage);

	if(DebugPrintLevel >= DebugLevel) 
    {
		if ((!ppdev) || (ppdev->debugMode & DEBUG_MODE_NT)) 
			EngDebugPrint(STANDARD_DEBUG_PREFIX, DebugMessage, ap);

		if(ppdev && (ppdev->debugMode & DEBUG_MODE_LOG)) 
        {
			char buffer[256];
			char *strPtr, *outPtr, *inPtr;
			int len;
			int prefixLen;
			BOOL newBeginIndex;
			int spaceRemaining;

			strPtr = &buffer[0];	// Pointer to beginning of output buffer 

			// STRIP OFF ANY LEADING NEWLINES 

			while(*DebugMessage == '\n')
				++DebugMessage;

			// FORMAT DEBUG STRING INTO BUFFER 

			len = vsprintf(strPtr, DebugMessage, ap);

			strPtr += len;

			// REMOVE ANY TRAILING NEWLINWE

			if(strPtr[-1] == '\n') 
				strPtr[-1] = '\0';
			else 
            {
				*strPtr = '\0';
				++len;
			}

			// COPY FORMATTED STRING TO CIRCULAR BUFFER 

			// FIGURE OUT SPACE BETWEEN END POINTER AND BEGINNING POINTER 
			
            if(ppdev->debugBegin > ppdev->debugEnd)
            {
				spaceRemaining = ppdev->debugBegin - ppdev->debugEnd;
            }
			else 
            {
				spaceRemaining = ppdev->debugBegin;
				spaceRemaining += DEBUG_LOG_SIZE - ppdev->debugEnd;
			}

			inPtr = &buffer[0];
			outPtr = &ppdev->debugLog[ppdev->debugEnd];

			if((ppdev->debugEnd + len) < DEBUG_LOG_SIZE) 
            {
				memcpy(outPtr, inPtr, len);
				ppdev->debugEnd += len;		
			} 
            else 
            {
				ULONG size;
				
				size = DEBUG_LOG_SIZE - ppdev->debugEnd;
				memcpy(outPtr, inPtr, size);
				inPtr += size;					// Update input ptr 
				outPtr = &ppdev->debugLog[0];	// And output ptr 
				size = len - size;
				memcpy(outPtr, inPtr, size);	// Copy rest of string 
				ppdev->debugEnd = size;			// Reset end index 
			}

			if(len >= spaceRemaining) 
            {
				ULONG index;
				UCHAR *debugLog;

				index = ppdev->debugEnd;
				debugLog = &ppdev->debugLog[0];

				for(;;) 
                {
					if(index >= DEBUG_LOG_SIZE)
						index = 0;

					if(debugLog[index] == (UCHAR) 0)
						break;

					++index;
				}

				++index;	
				if(index >= DEBUG_LOG_SIZE)
					ppdev->debugBegin = 0;
				else
					ppdev->debugBegin = index;
			}
		}
	}

	va_end(ap);
}

#endif // DBG
