 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * DirectDraw overlay support routines.
  * </DOC_AMD_STD>
  * 
  */

#include "precomp.h"
#include "gfx_type.h"
#include "gfx_regs.h"
#include "gfx_defs.h"

extern unsigned char *gfx_virt_vidptr;

extern int Format;
extern int uextra, vextra;
extern DWORD g_lLinearPitch;

BOOL
bIntersect(RECTL FAR *  pRcl1,
           RECTL FAR *  pRcl2,
           RECTL FAR *  pRclResult)
{
    pRclResult->left  = max(pRcl1->left,  pRcl2->left);
    pRclResult->right = min(pRcl1->right, pRcl2->right);

    //
    // Check if there an intersection horizontally
    //
    if ( pRclResult->left <= pRclResult->right )
    {
        pRclResult->top    = max(pRcl1->top,    pRcl2->top);
        pRclResult->bottom = min(pRcl1->bottom, pRcl2->bottom);

        if (pRclResult->top <= pRclResult->bottom)
        {
            //
            // Check if there an intersection vertically
            //
            return(TRUE);
        }
    }

      //
    // Return FALSE if there is no intersection
    //
    return(FALSE);
}// bIntersect()

/*---------------------------------------------------------------------
 * GetPaletteEntry
 *
 * Read an entry from the internal .
 ---------------------------------------------------------------------*/

DWORD GetPaletteEntry (PDEV *ppdev, DWORD key)
{
	DWORD data18;

	ppdev->myfuncs.pfn_get_display_palette_entry(key, &data18);
	return (data18);
}

/*---------------------------------------------------------------------
 * SetChromaKey
 *
 * Loads the chroma key color into COGNAC/KAHLUA
 * Key should be in Bpp specified
 *
 * If Key and Bpp are 0 then don't
 * chroma key (video always shown)
 *---------------------------------------------------------------------*/

BOOL SetChromaKey (PDEV *ppdev, DWORD Key, DWORD Bpp, int graphics)
{
	DWORD R,G,B;
	DWORD data32;

	if ((Key == 0) && (Bpp == 0))
	{
		ppdev->myfuncs.pfn_set_video_color_key(0,0,1);
	}
	else
	{
		if (Bpp == 16)
		{
			B =  (Key & 0x1f) << 3;
			G = ((Key >> 5) & 0x3f) << 2;
			R = ((Key >> 11) & 0x1f) << 3;
		}
		else if (Bpp == 8)
		{
			/* READ 8BPP PALETTE ENTRY */
			
			ppdev->myfuncs.pfn_get_display_palette_entry(Key, &data32);
			R = (data32 >> 16) & 0xFF;
			G = (data32 >> 8) & 0xFF;
			B =  data32 & 0xFF;
		}
		else
		{
			R = (Key & 0xFF0000) >> 16;
			G = (Key & 0x00FF00) >> 8;
			B = (Key & 0x0000FF);
		}	

		ppdev->myfuncs.pfn_set_video_color_key ((B | (G << 8) | (R << 16)),
			0x00FCFCFC, graphics);
	}

	return(TRUE);
}

/*--------------------------------------------------------------
 * bEnableGamma
 *
 * Initialize Gamma table for Cognac/Kahlua video
 --------------------------------------------------------------*/

BOOL bEnableGamma(PDEV *ppdev)
{
	/* SET PASS-THROUGH PALETTE */
	/* Some gamma correction will eventually be required, but for */
	/* the moment, just set an identity palette.                  */

	ppdev->myfuncs.pfn_set_video_palette (NULL);

	return(TRUE);
}

/*---------------------------------------------------------------------
 * SetVideoPalette
 *
 * Loads the video palette in COGNAC/KAHLUA (Gamma RAM)
 *
 *	RedGamma is the red channel gamma power factor
 *	GreenGamma is the green channel gamma power factor
 *	BlueGamma is the blue channel gamma power factor
 ---------------------------------------------------------------------*/

BOOL SetVideoPalette(PDEV *ppdev, BYTE *RedGamma, BYTE *GreenGamma, BYTE *BlueGamma)
{
	int i;
	double ImageRed, ImageGreen, ImageBlue, ImageIn;
	double InvRG, InvGG, InvBG;
	int Red, Green, Blue;
	int RedShift, GreenShift, BlueShift;
	double RedSlope, GreenSlope, BlueSlope;
	double RedG, GreenG, BlueG;
	ULONG palette[256];

	/* GAMMA */

	RedG = (double)(COLOR_RANGE - RedGamma[MODE_GAMMA]) / (double)COLOR_RANGE;
	RedG *= 2.0;
	if(RedG > 1.0) RedG = 1.0 + (RedG - 1.0) * 3.0;

	GreenG = (double)(COLOR_RANGE - GreenGamma[MODE_GAMMA]) / (double)COLOR_RANGE;
	GreenG *= 2.0;
	if(GreenG > 1.0) GreenG = 1.0 + (GreenG - 1.0) * 3.0;

	BlueG = (double)(COLOR_RANGE - BlueGamma[MODE_GAMMA]) / (double)COLOR_RANGE;
	BlueG *= 2.0;
	if(BlueG > 1.0) BlueG = 1.0 + (BlueG - 1.0) * 3.0;

	InvRG = 1.0 / (double)RedG;
	InvGG = 1.0 / (double)GreenG;
	InvBG = 1.0 / (double)BlueG;

	/* BRIGHTNESS */

	RedShift   = (COLOR_RANGE - RedGamma[MODE_BRIGHT]); // Scale to 0-255
	GreenShift = (COLOR_RANGE - GreenGamma[MODE_BRIGHT]);
	BlueShift  = (COLOR_RANGE - BlueGamma[MODE_BRIGHT]);
	RedShift   -= COLOR_MID;
	GreenShift -= COLOR_MID;
	BlueShift  -= COLOR_MID;

	/* CONTRAST */

	RedSlope = (double)(COLOR_RANGE - RedGamma[MODE_CONTRAST]) / (double)COLOR_RANGE;
	RedSlope *= 2.0;
	if(RedSlope > 1.0) RedSlope = 1.0 + (RedSlope - 1.0) * 5.0;

	GreenSlope = (double)(COLOR_RANGE - GreenGamma[MODE_CONTRAST]) / (double)COLOR_RANGE;
	GreenSlope *= 2.0;
	if(GreenSlope > 1.0) GreenSlope = 1.0 + (GreenSlope - 1.0) * 5.0;

	BlueSlope = (double)(COLOR_RANGE - BlueGamma[MODE_CONTRAST]) / (double)COLOR_RANGE;
	BlueSlope *= 2.0;
	if(BlueSlope > 1.0) BlueSlope = 1.0 + (BlueSlope - 1.0) * 5.0;

	/* LOAD PALETTE */

	for(i = 0; i < 256; i++)
	{
		ImageIn = (double)i / 255.0;
		ImageRed	= pow(ImageIn,InvRG);
		ImageGreen	= pow(ImageIn,InvGG);
		ImageBlue	= pow(ImageIn,InvBG);

		Red   = (int)(ImageRed * 255.0);
		Green = (int)(ImageGreen * 255.0);
		Blue  = (int)(ImageBlue * 255.0);

		Red   = (int)(Red * RedSlope);
		Green = (int)(Green * GreenSlope);
		Blue  = (int)(Blue * BlueSlope);

		Red   += RedShift;
		Green += GreenShift;
		Blue  += BlueShift;

		if(Red < 0) Red = 0;	 if(Red > 255) Red = 255;
		if(Green < 0) Green = 0; if(Green > 255) Green = 255;
		if(Blue < 0) Blue = 0;	 if(Blue > 255) Blue = 255;
		
		palette[i] = ((DWORD)Blue)       |
					 ((DWORD)Green << 8) |
					 ((DWORD)Red   << 16);	
	}

	ppdev->myfuncs.pfn_set_video_palette (palette);

	return(TRUE);
}

/*---------------------------------------------------------------------
 * SetVideoPosition
 *
 * Sets the position and size of the overlay window
 * If SizeValid is true, then use passed in Width, Height else
 * use saved state.
 *---------------------------------------------------------------------*/

BOOL SetVideoPosition(
	PDEV *ppdev,
	DWORD XPos,
	DWORD YPos,
	DWORD Width,
	DWORD Height,
	BOOL SizeValid)
{
	RECTL display, ovly, result;
	static DWORD XSize = 0;
	static DWORD YSize = 0;
	long xstart, xend, ystart, yend, xclip = 0;
	unsigned long lines, offset;
	unsigned long xcrop, vcfg;

	if (SizeValid)
	{
		XSize = Width;
		YSize = Height;
	}

	/* UPDATE POSITION */
	/* We account for panel panning */
        
	xstart = XPos;
	xend   = XPos + XSize;
	ystart = YPos;
	yend   = YPos + YSize;

	/* ACCOUNT FOR TOP AND LEFT CLIPPING */
	/* Some applications, such as Windows Media Player, clip the video */
	/* window by decreasing the overlay width and sending a non-zero   */
	/* x coordinate.                                                   */

	lines = ppdev->clippedSrcLines;
	xcrop = ppdev->xcrop;

	if (*(ppdev->myfuncs.pPanelEnable))
	{
		ovly.left   = xstart;
		ovly.right  = xend;
		ovly.top    = ystart;
		ovly.bottom = yend;
	
		display.left    = *(ppdev->myfuncs.pDeltaX);
		display.right   = *(ppdev->myfuncs.pDeltaX) + *(ppdev->myfuncs.pPanelWidth);
		display.top     = *(ppdev->myfuncs.pDeltaY);
		display.bottom  = *(ppdev->myfuncs.pDeltaY) + *(ppdev->myfuncs.pPanelHeight);
			        
		/* CHECK FOR VIDEO WINDOW DISPLAYED */
		
		xstart = xend = 0;
		if (bIntersect(&display, &ovly, &result))
		{
			xstart = ovly.left   - (long)(*(ppdev->myfuncs.pDeltaX));
			xend   = ovly.right  - (long)(*(ppdev->myfuncs.pDeltaX));
			ystart = ovly.top    - (long)(*(ppdev->myfuncs.pDeltaY)); 
			yend   = ovly.bottom - (long)(*(ppdev->myfuncs.pDeltaY));			
		}		
	}

	/* CHECK FOR TOP CLIPPING FROM PANNING OR NEGATIVE COORDINATES */

	if (ystart < 0)
	{
		lines  += (-ystart * ppdev->video_src_height) / ppdev->video_dst_height;
		ystart = 0;
	}
	if (xstart < 0)
	{
		xcrop += (-xstart) * ppdev->video_src_width / ppdev->video_dst_width;;
		xstart = 0;
	}
	
	ppdev->myfuncs.pfn_set_video_window ((short)xstart, (short)ystart, (short)(xend - xstart), (short)(yend - ystart)); 
	
	if (Format == VIDEO_FORMAT_Y0Y1Y2Y3)
		xcrop &= 0xFFF8;
	else
		xcrop &= 0xFFFC;

	/* SAVE AND SET THE VIDEO OFFSET */

	ppdev->video_buffer_offset = lines * g_lLinearPitch;
	ppdev->video_buffer_uv_offset = (lines >> 1) * (g_lLinearPitch >> 1);

	SetVideoOffset (ppdev, ppdev->video_offset);

	/* SET THE INITIAL BUFFER READ ADDRESS */

	vcfg = READ_VID32(RCDF_VIDEO_CONFIG);
	vcfg &= ~RCDF_VCFG_INIT_READ_MASK;
	vcfg |= (xcrop << 15) & RCDF_VCFG_INIT_READ_MASK;
	WRITE_VID32(RCDF_VIDEO_CONFIG, vcfg);

	return(TRUE);
}

/*--------------------------------------------------------------------------------
 * SetVideoOffset
 *
 * Set the offset into the framebuffer from where the GX is to fetch video data.
 --------------------------------------------------------------------------------*/

BOOL SetVideoOffset(PDEV *ppdev, DWORD Offset)
{
    DWORD YSteps;
	long lines;

    ppdev->video_offset = Offset;
    
	/* OFFSET PREVIOUSLY CALCULATED IN SETVIDEOPOSITION */

	if (Format != VIDEO_FORMAT_Y0Y1Y2Y3)
	{
		ppdev->myfuncs.pfn_set_video_offset (Offset + ppdev->video_buffer_offset);
	}
	else
	{
		ppdev->myfuncs.pfn_set_video_yuv_offsets (
			Offset + ppdev->video_buffer_offset, 
			Offset + uextra + ppdev->video_buffer_uv_offset,
			Offset + vextra + ppdev->video_buffer_uv_offset);
	}
    
    return(TRUE);
}