 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * DirectDraw supplement routines.
  * </DOC_AMD_STD>
  * 
  */

#include "precomp.h"

DWORD DdGetAvailDriverMemory (PDD_GETAVAILDRIVERMEMORYDATA lpGetAvailDriverMemory);

// PREDEFINED MISCELLANEOUS CALLBACKS
//
const DD_MISCELLANEOUSCALLBACKS GX2MiscellaneousCallbacks =
{
    sizeof (DD_MISCELLANEOUSCALLBACKS),
    DDHAL_MISCCB32_GETAVAILDRIVERMEMORY,
    DdGetAvailDriverMemory
};

/////////////////////////////////////////////////////////////////////////
// DWORD DDGetDriverInfo
//
DWORD DdGetDriverInfo(PDD_GETDRIVERINFODATA lpData)
{
	PDEV *ppdev = NULL;

    ppdev = (PDEV*) lpData->dhpdev;
	lpData->ddRVal = DDERR_CURRENTLYNOTAVAIL;

    DISPDBG((ppdev,200,"DdGetDriverInfo Begins\n"));

	if (IsEqualIID(&(lpData->guidInfo), &GUID_MiscellaneousCallbacks) )
    {
        DWORD dwSize = min(lpData->dwExpectedSize, sizeof(DD_MISCELLANEOUSCALLBACKS));
    
		lpData->dwActualSize = sizeof(DD_MISCELLANEOUSCALLBACKS);
 
		DISPDBG ((ppdev,2000, "GetDriverInfo: Miscellaneous Callbacks\n"));

		memcpy (lpData->lpvData, &GX2MiscellaneousCallbacks, dwSize);
		lpData->ddRVal = DD_OK;
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_VideoPortCallbacks) )
    { 
		DISPDBG ((ppdev,200, "GetDriverInfo: VideoPortCallbacks\n"));
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_VideoPortCaps) )
    {
		DISPDBG ((ppdev, 200, "GetDriverInfo: VideoPort Caps\n"));
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_NTCallbacks) )
    {
		DISPDBG ((ppdev, 200, "GetDriverInfo: NT Callbacks\n"));
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_KernelCallbacks) )
    {
		DISPDBG ((ppdev, 200, "GetDriverInfo: Kernel Callbacks\n"));
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_KernelCaps) )
    {
		DISPDBG ((ppdev, 200, "GetDriverInfo: Kernel Caps\n"));
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_ColorControlCallbacks) )
    {
        DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_ColorControlCallbacks\n"));
    }
	if (IsEqualIID(&(lpData->guidInfo), &GUID_ZPixelFormats) )
    {
		 DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_ZPixelFormats\n"));
    }
	if (IsEqualIID(&(lpData->guidInfo), &GUID_D3DExtendedCaps) )
    {
		DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_D3DExtendedCaps\n"));	
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_D3DCallbacks) )
    {
		DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_D3DCallbacks\n"));	
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_D3DCallbacks3) )
    {
		DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_D3DCallbacks3\n"));	
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_GetHeapAlignment) )
    {
		DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_GetHeapAlignment\n"));	
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_Miscellaneous2Callbacks) )
    {
		DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_Miscellaneous2Callbacks\n"));	
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_MotionCompCallbacks) )
    {
		DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_MotionCompCallbacks\n"));	
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_NonLocalVidMemCaps) )
    {
		DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_UpdateNonLocalHeap\n"));	
    }
    if (IsEqualIID(&(lpData->guidInfo), &GUID_UpdateNonLocalHeap) )
    {
		DISPDBG((ppdev,200,"DdGetDriverInfo: Checking for GUID_NonLocalVidMemCaps\n"));	
    }

    DISPDBG((ppdev,200," \nDdGetDriverInfo Leaves\n"));
    return DDHAL_DRIVER_HANDLED;
}

/////////////////////////////////////////////////////////////////////////
// DdGetAvailDriverMemory
//
// This routine is called to retrieve the current state of the DirectDraw heap.
//
DWORD DdGetAvailDriverMemory (PDD_GETAVAILDRIVERMEMORYDATA lpGetAvailDriverMemory)
{
    PDEV *ppdev = NULL;
    DISPDBG ((ppdev, 200, "DdGetAvailDriverMemory\n"));
    lpGetAvailDriverMemory->ddRVal  = DD_OK;
    lpGetAvailDriverMemory->dwTotal = heap_end - heap_start;
    lpGetAvailDriverMemory->dwFree  = ddraw_offset - heap_start;

    return DDHAL_DRIVER_HANDLED;
}