 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Brush Realization and creation via DrvRealizeBrush
  * </DOC_AMD_STD>
  * 
  */

#include "precomp.h"

/////////////////////////////////////////////////////////////////////////
// DrvRealizeBrush
//
// Translate brushes into a form that the driver can use.
//
BOOL DrvRealizeBrush(
	BRUSHOBJ * pbo,
	SURFOBJ * psoTarget,
	SURFOBJ * psoPattern,
	SURFOBJ * psoMask,
	XLATEOBJ * pxlo,
	ULONG iHatch)
{
	PBRUSH PBrush;
	PPBRUSH pPBrush;
	INT cjPattern, cjMask;
	PBYTE pbMask;
	INT i, j, cx, cy, lSrcDelta, lDestDelta;
	PBYTE pbSrcBits, pbSrc, pbDest;
	FLONG flXlate;
	PULONG puXlate;
	PDEV *ppdev = NULL; /* To satisfy debug printing */

	DISPDBG((ppdev, 1, "DrvRealizeBrush Enters\n"));

	/* Reject any brushes that the driver can't handle. */
	if((psoPattern->sizlBitmap.cx != 8) || (psoPattern->sizlBitmap.cy != 8)) {
		DISPDBG((ppdev, 300, "Can only handle 8x8 bitmaps, not %dx%d\n",
				psoPattern->sizlBitmap.cx, psoPattern->sizlBitmap.cy));
		return FALSE;
	}

	if(psoPattern->iType != STYPE_BITMAP) {
		DISPDBG((ppdev, 300, "Can only handle STYPE_BITMAP (%d), not %d\n",
				STYPE_BITMAP, psoPattern->iType));
		return FALSE;
	}

	if(psoPattern->iBitmapFormat != BMF_1BPP)
	{
		DISPDBG((ppdev, 300, "Can only handle BMF_1BPP (%d) and BMF_8BPP (%d) not %d\n",
				BMF_1BPP, BMF_8BPP, psoPattern->iBitmapFormat));
		return FALSE;
	}

	/* The driver can realize this brush. */
	cx = psoPattern->sizlBitmap.cx;
	cy = psoPattern->sizlBitmap.cy;

	/* Clear PBrush structure to 0 */
	memset(&PBrush, 0, sizeof(PBrush));

	/* Handle standard 1 or 8 bpp bitmap format for now */
	PBrush.iType = psoPattern->iType;
	PBrush.iBitmapFormat = psoPattern->iBitmapFormat;

	/* Get the size of the bitmap, we'll need this in a few places. */
	/* Calculate the size of the PBrush Structure. */
	PBrush.nSize = sizeof(PBrush);
	PBrush.sizlPattern = psoPattern->sizlBitmap;

	if(PBrush.iBitmapFormat == BMF_8BPP) {
		cjPattern = psoPattern->cjBits;
		PBrush.nSize += cjPattern;
		PBrush.lDeltaPattern = abs(psoPattern->lDelta);
	} else {					/* (PBrush.iBitmapFormat == BMF_1BPP) */
		lDestDelta = cx / 8;
		cjPattern = lDestDelta * cy;
		PBrush.nSize += cjPattern;
		PBrush.lDeltaPattern = lDestDelta;
	}

	/* If there is a mask add in the size of the mask, */
	/* while we're at it record that we have a mask. */

	if(psoMask) {
		PBrush.flags |= PBRUSH_MASK;
		cjMask = psoMask->cjBits;		/* mask size in bytes */
		PBrush.nSize += cjMask;
		PBrush.sizlMask = psoMask->sizlBitmap;	/* mask dim in xy */
		PBrush.lDeltaMask = psoMask->lDelta;	/* mask row pitch */
	}

	/* Get xlate info */
	flXlate = 0;

	if(pxlo != NULL) {
		flXlate = pxlo->flXlate;
		puXlate = pxlo->pulXlate;
	}

	/* Allocate static storage and move the stack copy of PBrush over */
	pPBrush = (PPBRUSH) BRUSHOBJ_pvAllocRbrush(pbo, PBrush.nSize);
	if (pPBrush == NULL){
		return FALSE;
	}
	else
	*pPBrush = PBrush;

	/* Copy the pattern */
	if(PBrush.iBitmapFormat == BMF_8BPP) {
		if(psoPattern->fjBitmap & BMF_TOPDOWN) {
			pbSrc = psoPattern->pvBits;
			pbDest = pPBrush->Pattern;

			if(flXlate & XO_TABLE)
				for(j = 0; j < cjPattern; j++)
					pbDest[j] = (BYTE) puXlate[pbSrc[j]];

			else
				memcpy(pPBrush->Pattern, psoPattern->pvBits, cjPattern);
		} else {				/* (psoPattern->fjBitmap != BMF_TOPDOWN) */
			pbSrc = psoPattern->pvScan0;
			pbDest = pPBrush->Pattern;
			lSrcDelta = psoPattern->lDelta;
			lDestDelta = -lSrcDelta;

			if(flXlate & XO_TABLE)
				for(i = 0; i < cy; i++) {
					for(j = 0; j < cx; j++)
						pbDest[j] = (BYTE) puXlate[pbSrc[j]];

					pbSrc += lSrcDelta;
					pbDest += lDestDelta;
				}

			else
				for(i = 0; i < cy; i++) {
					memcpy(pbDest, pbSrc, cx);
					pbSrc += lSrcDelta;
					pbDest += lDestDelta;
				}
		}
	} else {					/* (PBrush.iBitmapFormat == BMF_1BPP) */
		if(!((psoPattern->fjBitmap) & BMF_TOPDOWN)) {
			pbSrcBits = psoPattern->pvScan0;
		} else {
			pbSrcBits = (PBYTE) psoPattern->pvBits;
		}

		pbDest = pPBrush->Pattern;
		lSrcDelta = psoPattern->lDelta;

		pPBrush->flags |= PBRUSH_2COLOR;
		DISPDBG((ppdev, 0, "Adding 2Color flag to get 0x%x\n", pPBrush->flags));
		pPBrush->Color1 = puXlate[1];
		pPBrush->Color0 = puXlate[0];

		for(i = 0; i < cy; i++) {
			pbSrc = pbSrcBits + (i * lSrcDelta);
			*pbDest++ = *pbSrc;
		}
		{
		long i;
		UCHAR *bits;
		bits = pPBrush->Pattern;
		for(i=0; i<cy; i+=8, bits+=8) {
			DISPDBG((ppdev, 0, "Pattern[%d] = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\n",
				i, bits[0], bits[1], bits[2], bits[3], bits[4], bits[5], bits[6], bits[7]));
		}
		}
	}

	/* Copy the mask */
	if(PBrush.flags & PBRUSH_MASK) {
		pbMask = pPBrush->Pattern + cjPattern;
		memcpy(pbMask, psoMask->pvBits, cjMask);

		{
		long i;
		UCHAR *bits;
		bits = psoMask->pvBits;
		for(i=0; i<cjMask; i+=8, bits+=8) {
			DISPDBG((ppdev, 0, "Mask[%d] = 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\n",
				i, bits[0], bits[1], bits[2], bits[3], bits[4], bits[5], bits[6], bits[7]));
		}
		}
	}

	DISPDBG((ppdev, 0, "Final flags 0x%x\n", pPBrush->flags));
	return TRUE;
}
