 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Display Driver Applet definitions.
  * </DOC_AMD_STD>
  * 
  */

#ifndef __DISPLAYCPLEXT_H_
#define __DISPLAYCPLEXT_H_

#include "resource.h"       // main symbols
#include <comdef.h>
#include <shlobj.h>
#include "..\display\escape.h"

typedef struct tagRegistryStruct
{
    unsigned long secretWord;
    unsigned long unused;
    RegistryData driverStruct;
} REGISTRY_DATA;


/////////////////////////////////////////////////////////////////////////////
// CDisplayCplExt

class ATL_NO_VTABLE CDisplayCplExt : 
    public CComObjectRootEx<CComSingleThreadModel>,
    public CComCoClass<CDisplayCplExt, &CLSID_DisplayCplExt>,
    public IDispatchImpl<IDisplayCplExt, &IID_IDisplayCplExt, &LIBID_DISPLAYPAGELib>,
    public IShellExtInit,
    public IShellPropSheetExt
{
public:
    CDisplayCplExt()
    {
    }

DECLARE_REGISTRY_RESOURCEID(IDR_DISPLAYCPLEXT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CDisplayCplExt)
    COM_INTERFACE_ENTRY(IDisplayCplExt)
    COM_INTERFACE_ENTRY(IDispatch)
    COM_INTERFACE_ENTRY(IShellExtInit)
    COM_INTERFACE_ENTRY(IShellPropSheetExt)
END_COM_MAP()

public:
    // IDisplayCplExt

    // IShellExtInit
    STDMETHOD(Initialize)(LPCITEMIDLIST pidlFolder,
                          IDataObject *lpdobj, HKEY hkeyProgID);

    // IShellPropSheetExt
    STDMETHOD(AddPages)(LPFNADDPROPSHEETPAGE lpfnAddPage, LPARAM lParam);
    STDMETHOD(ReplacePage)(UINT uPageID, LPFNADDPROPSHEETPAGE lpfnReplaceWith, LPARAM lParam);
};

#endif //__DISPLAYCPLEXT_H_
