 /*
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * Display Driver Applet main file.
  * </DOC_AMD_STD>
  * 
  */

#include "stdafx.h"
#include "DisplayPage.h"
#include "DisplayCplExt.h"
#include <cplext.h>

#define MB_INFO MB_OK | MB_ICONINFORMATION

BOOL CALLBACK NewPageDlgProc ( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
UINT CALLBACK NewPageCallbackProc ( HWND hwnd, UINT uMsg, LPPROPSHEETPAGE ppsp );

BOOL CALLBACK ReplacementPageDlgProc ( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
UINT CALLBACK ReplacementPageCallbackProc ( HWND hwnd, UINT uMsg, LPPROPSHEETPAGE ppsp );


REGISTRY_DATA RegData;
ULONG Compression;
ULONG DDCEnabled;
ULONG FBLinear;
ULONG AntialiasedText;
BOOL RegUpdate=FALSE;

int comp_ids[] = {IDC_COMPRESSION_OFF, IDC_COMPRESSION_DYNAMIC, IDC_COMPRESSION_ON };
int fb_ids[]   = {IDC_POWER_OF_TWO, IDC_LINEAR_DYNAMIC, IDC_LINEAR_ON};

/////////////////////////////////////////////////////////////////////////////
// CDisplayCplExt

STDMETHODIMP CDisplayCplExt::Initialize ( LPCITEMIDLIST pidlFolder,
                                          IDataObject*  lpdobj, 
                                          HKEY          hkeyProgID )
{
    // Do any initialization here.  pidlFolder and lpdobj are both NULL, so you
    // can ignore them.
   
	
	return S_OK;
}

STDMETHODIMP CDisplayCplExt::AddPages ( LPFNADDPROPSHEETPAGE lpfnAddPage,
                                        LPARAM lParam )
{
    // This method adds a new page to the Display property sheet.

PROPSHEETPAGE  psp;
HPROPSHEETPAGE hPage;
DWORD dwType = REG_DWORD; 
int RetVal;
HDC dc;

    // Set up the PROPSHEETPAGE struct.

    ZeroMemory ( &psp, sizeof(PROPSHEETPAGE) );

    psp.dwSize      = sizeof(PROPSHEETPAGE);
    psp.dwFlags     = PSP_USEREFPARENT | PSP_DEFAULT | PSP_USECALLBACK | PSP_USEHICON;
    psp.hInstance   = _Module.GetResourceInstance();
    psp.pszTemplate = MAKEINTRESOURCE(IDD_PROPPAGE_MEDIUM);
    psp.pfnDlgProc  = NewPageDlgProc;
    psp.pfnCallback = NewPageCallbackProc;
    psp.pcRefParent = (UINT*) &_Module.m_nLockCnt;
    psp.hIcon       = LoadIcon(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDI_AMD_ICON));

    // Create the page & get a handle to it.

    hPage = CreatePropertySheetPage ( &psp );

    if ( NULL != hPage )
        {
        // Call the shell's callback function, so it adds the page to
        // the property sheet.
		dc = GetDC (NULL);

        RegData.secretWord = GX2_SECRET_WORD;
		RegData.driverStruct.Flag = REG_ALL;
			
		RetVal = ExtEscape (dc, DISPPERF_EXTESC_GETPARAM, sizeof(RegData), (LPCSTR)&RegData, sizeof(RegData), (LPSTR)&RegData );
		ReleaseDC(NULL, dc);

		if (RetVal <= 0) 
			{
				//MessageBox(NULL,"Error Loading ",	"Warning",MB_INFO);
				DestroyPropertySheetPage ( hPage );	
				return S_OK;
			}    

        if ( !lpfnAddPage ( hPage, lParam ))
            {
				DestroyPropertySheetPage ( hPage );
            }
        }

    return S_OK;
}

STDMETHODIMP CDisplayCplExt::ReplacePage ( UINT uPageID, 
                                           LPFNADDPROPSHEETPAGE lpfnReplaceWith,
                                           LPARAM lParam )
{
    // This method replaces the Background page of the property sheet.

    // Check that we're being called with the page ID we expect.
    /*if ( CPLPAGE_DISPLAY_BACKGROUND != uPageID )
        return S_OK;*/

PROPSHEETPAGE  psp;
HPROPSHEETPAGE hPage;

    // Set up the PROPSHEETPAGE struct.

    ZeroMemory ( &psp, sizeof(PROPSHEETPAGE) );

    psp.dwSize      = sizeof(PROPSHEETPAGE);
    psp.dwFlags     = PSP_USEREFPARENT | PSP_DEFAULT | PSP_USECALLBACK | PSP_USEHICON;
    psp.hInstance   = _Module.GetResourceInstance();
    psp.pszTemplate = MAKEINTRESOURCE(IDD_PROPPAGE_MEDIUM);
    psp.pfnDlgProc  = NewPageDlgProc;
    psp.pfnCallback = NewPageCallbackProc;
    psp.pcRefParent = (UINT*) &_Module.m_nLockCnt;
    psp.hIcon       = LoadIcon(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDI_AMD_ICON));

    // Create the page & get a handle to it.

    hPage = CreatePropertySheetPage ( &psp );

    if ( NULL != hPage )
        {
        // Call the shell's callback function, so it adds the page to
        // the property sheet.
        
        if ( !lpfnReplaceWith ( hPage, lParam ))
            {
            DestroyPropertySheetPage ( hPage );
            }
        }
	
    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// Functions for the page we add to the property sheet

BOOL CALLBACK NewPageDlgProc ( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
    PAINTSTRUCT ps;
    HBITMAP hbmp;
	BOOL bRet = FALSE;
	LONG rc =0;
	DWORD dwType = REG_DWORD; 
	int RetVal1;
	HDC dc, memdc;

    // Put your normal dialog proc code here...

   	switch (uMsg)
	{
		case WM_INITDIALOG :

			dc = GetDC (NULL);

            RegData.secretWord = GX2_SECRET_WORD;
			RegData.driverStruct.Flag = REG_ALL;
			
			RetVal1 = ExtEscape (dc, DISPPERF_EXTESC_GETPARAM, sizeof(RegData), (LPCSTR)&RegData, sizeof(RegData), (LPSTR)&RegData );
						
			ReleaseDC(NULL, dc);
			
			if (RetVal1 <= 0) 
			{
				MessageBox(NULL,"Error reading from Registry",	"Warning",MB_INFO);
				return FALSE;
			}
			else 
			{
				Compression     = RegData.driverStruct.Compression;
				DDCEnabled      = RegData.driverStruct.DDCEnabled;
				FBLinear        = RegData.driverStruct.FBLinear;
				AntialiasedText = RegData.driverStruct.AntialiasedText;
								
				CheckDlgButton(hwnd, IDC_DDC, DDCEnabled ? BST_CHECKED : BST_UNCHECKED);
								
				if (Compression < 3)
					CheckRadioButton (hwnd, comp_ids[0], comp_ids[2], comp_ids[Compression]); 
				if (FBLinear < 3)
					CheckRadioButton (hwnd, fb_ids[0], fb_ids[2], fb_ids[FBLinear]);
				
				CheckDlgButton (hwnd, IDC_ANTIALIASED, 
					AntialiasedText ? BST_CHECKED : BST_UNCHECKED);
	
			}
			break;

        case WM_PAINT:

            dc = BeginPaint (hwnd, &ps);
            memdc = CreateCompatibleDC (dc);
            if (memdc && dc)
            {
                hbmp = (HBITMAP)LoadImage (_Module.GetResourceInstance(), MAKEINTRESOURCE (IDB_AMD_LOGO), IMAGE_BITMAP,
                    0, 0, 0);

                if (hbmp)
                {
                    SelectObject (memdc, hbmp);
                    TransparentBlt (dc, 60, 10, 210, 72, memdc, 0, 0, 210, 72, 0xd8e9ec);
                    DeleteObject (hbmp);
                }
                DeleteDC (memdc);
                EndPaint(hwnd, &ps); 
                return TRUE;
            }
            break;

		case WM_NOTIFY :
			{
				NMHDR *phdr = (NMHDR *) lParam;
				switch(phdr->code)
				{
				case PSN_APPLY: //The Apply button has been clicked
					RegData.driverStruct.Compression     = Compression;
					RegData.driverStruct.DDCEnabled      = DDCEnabled;
					RegData.driverStruct.FBLinear        = FBLinear;
					RegData.driverStruct.AntialiasedText = AntialiasedText;
					RegData.driverStruct.Flag            = REG_ALL; //Easy - Set all
					RegData.secretWord = GX2_SECRET_WORD;                    
                    dc = GetDC(NULL);
					
					RetVal1 = ExtEscape (dc, DISPPERF_EXTESC_SETPARAM, sizeof(RegData), (LPCSTR)&RegData, sizeof(RegData), (LPSTR)&RegData );
					ReleaseDC(NULL, dc);
					if (RetVal1 <= 0) 
					{
						MessageBox(NULL,"GX Registry Not Updated !!!", "Error",MB_INFO);
					}
					else
					{
						if (RegUpdate)
						{
							RegUpdate=FALSE;
							//MessageBox(NULL,"RegUpdate TRUE!!!", "Error",MB_INFO);
							SendMessage(GetParent(hwnd), PSM_RESTARTWINDOWS, 0, 0);
						}
					}
				case PSN_RESET: // Don't care for now
				case PSN_SETACTIVE:
				case PSN_KILLACTIVE:
				default:
					break;
				}
			}
			//Send the message all went well
			SetWindowLong(hwnd, DWL_MSGRESULT, PSNRET_NOERROR);
			break;
		case WM_COMMAND :
			//User has changed some of the settings
			switch (LOWORD (wParam))
			{
			case IDC_COMPRESSION_OFF:
				RegUpdate=TRUE;

				Compression = 0;
				break;

			case IDC_COMPRESSION_DYNAMIC:
				RegUpdate=TRUE;

				Compression = 1;
				break;

			case IDC_COMPRESSION_ON:
				RegUpdate=TRUE;

				Compression = 2;
				break;

			
			case IDC_POWER_OF_TWO:
				RegUpdate=TRUE;

				FBLinear = 0;
				break;

			case IDC_LINEAR_DYNAMIC:
				RegUpdate=TRUE;

				FBLinear = 1;
				break;

			case IDC_LINEAR_ON:
				RegUpdate=TRUE;

				FBLinear = 2;
				break;

			case IDC_DDC:
				RegUpdate=TRUE;
				if(IsDlgButtonChecked(hwnd, IDC_DDC))
					DDCEnabled= 1;
				else
					DDCEnabled = 0;
				break;

			case IDC_ANTIALIASED:
				RegUpdate = TRUE;

				AntialiasedText = (IsDlgButtonChecked(hwnd, IDC_ANTIALIASED)) ? 1 : 0;
				break;
			}

			if(RegUpdate)
			{
				// Notify parrent things have changed and enable "Apply" button.
			
				SendMessage(GetParent(hwnd), PSM_CHANGED, (WPARAM) hwnd, 0);
			}
			break;
		default:
			return FALSE;
	}
  return TRUE;
}

UINT CALLBACK NewPageCallbackProc ( HWND hwnd, UINT uMsg, LPPROPSHEETPAGE ppsp )
{


    switch ( uMsg )
        {
        case PSPCB_CREATE:
            // The page is being created.  Return nonzero to let it be created,
            // zero to destroy it.
            return 1;
        break;

        case PSPCB_RELEASE:
            // The page is being destroyed.  Put any cleanup code (eg, free up
            // memory or resources) here.  The return value is ignored.
            return 0;
        break;
        }

    return 0;
}


/////////////////////////////////////////////////////////////////////////////
// Functions for the replacement background page

BOOL CALLBACK ReplacementPageDlgProc ( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	
    // Put your normal dialog proc code here...
    return FALSE;
}

UINT CALLBACK ReplacementPageCallbackProc ( HWND hwnd, UINT uMsg, LPPROPSHEETPAGE ppsp )
{return FALSE;
}

 
