 /*
  * 
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * This file contains routines to read machine-specific registers (MSRs)
  * 
  * Routines:
  * 
  *       gfx_msr_init
  *       gfx_id_msr_device
  *       gfx_get_msr_dev_address
  *       gfx_get_glink_id_at_address
  *       gfx_msr_read
  *       gfx_msr_write
  * </DOC_AMD_STD>
  * 
  */


/* INCLUDE SUPPORT FOR REDCLOUD, IF SPECIFIED */

#if GFX_MSR_REDCLOUD
#include "msr_rdcl.c"
#endif

/* EXTRA WRAPPERS FOR DYNAMIC SELECTION */

#if GFX_MSR_DYNAMIC

/*-----------------------------------------------------------------------------
 * gfx_msr_init
 *-----------------------------------------------------------------------------
 */
int gfx_msr_init ()
{
	int ret_value = 0;

#if GFX_MSR_REDCLOUD
	if (gfx_msr_type & GFX_MSR_TYPE_REDCLOUD)
		ret_value = redcloud_msr_init();
#endif

	return ret_value;
}

/*-----------------------------------------------------------------------------
 * gfx_id_msr_device
 *-----------------------------------------------------------------------------
 */
DEV_STATUS gfx_id_msr_device (MSR *pDev, unsigned long address)
{
	DEV_STATUS ret_value = NOT_KNOWN;

#if GFX_MSR_REDCLOUD
	if (gfx_msr_type & GFX_MSR_TYPE_REDCLOUD)
		ret_value = redcloud_id_msr_device(pDev, address);
#endif

	return ret_value;
}

/*-----------------------------------------------------------------------------
 * gfx_get_msr_dev_address
 *-----------------------------------------------------------------------------
 */
DEV_STATUS gfx_get_msr_dev_address (unsigned int device, unsigned long *address)
{
	DEV_STATUS ret_value = NOT_KNOWN;

#if GFX_MSR_REDCLOUD
	if (gfx_msr_type & GFX_MSR_TYPE_REDCLOUD)
		ret_value = redcloud_get_msr_dev_address (device, address);
#endif

	return ret_value;
}

/*-----------------------------------------------------------------------------
 * gfx_get_glink_id_at_address
 *-----------------------------------------------------------------------------
 */
DEV_STATUS gfx_get_glink_id_at_address(unsigned int *device, unsigned long address)
{
	DEV_STATUS ret_value = NOT_KNOWN;

#if GFX_MSR_REDCLOUD
	if (gfx_msr_type & GFX_MSR_TYPE_REDCLOUD)
		ret_value = redcloud_get_glink_id_at_address (device, address);
#endif

	return ret_value;
}

/*-----------------------------------------------------------------------------
 * gfx_msr_read
 *-----------------------------------------------------------------------------
 */
DEV_STATUS gfx_msr_read (unsigned int device, unsigned int msrRegister, Q_WORD *msrValue)
{
	DEV_STATUS ret_value = NOT_KNOWN;

#if GFX_MSR_REDCLOUD
	if (gfx_msr_type & GFX_MSR_TYPE_REDCLOUD)
		ret_value = redcloud_msr_read (device, msrRegister, msrValue);
#endif

	return ret_value;
}

/*-----------------------------------------------------------------------------
 * gfx_msr_write
 *-----------------------------------------------------------------------------
 */
DEV_STATUS gfx_msr_write (unsigned int device, unsigned int msrRegister, Q_WORD *msrValue)
{
	DEV_STATUS ret_value = NOT_KNOWN;

#if GFX_MSR_REDCLOUD
	if (gfx_msr_type & GFX_MSR_TYPE_REDCLOUD)
		ret_value = redcloud_msr_write(device, msrRegister, msrValue);
#endif

	return ret_value;
}

#endif
