 /*
  * 
  * <LIC_AMD_STD>
  * Copyright (C) <years> Advanced Micro Devices, Inc.  All Rights Reserved.
  * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * This header file contains the mode tables.  It is used by the "gfx_disp.c" 
  * file to set a display mode.
  * </DOC_AMD_STD>
  * 
  */


#ifndef _gfx_mode_h
#define _gfx_mode_h

/* MODE FLAGS (BITWISE-OR) */

#define GFX_MODE_8BPP		  0x00000001
#define GFX_MODE_12BPP        0x00000002
#define GFX_MODE_15BPP        0x00000004
#define GFX_MODE_16BPP		  0x00000008
#define GFX_MODE_24BPP        0x00000010
#define GFX_MODE_56HZ         0x00000020
#define GFX_MODE_60HZ		  0x00000040
#define GFX_MODE_70HZ		  0x00000080
#define GFX_MODE_72HZ		  0x00000100
#define GFX_MODE_75HZ		  0x00000200
#define GFX_MODE_85HZ		  0x00000400
#define GFX_MODE_90HZ         0x00000800
#define GFX_MODE_100HZ        0x00001000
#define GFX_MODE_NEG_HSYNC	  0x00002000
#define GFX_MODE_NEG_VSYNC	  0x00004000
#define GFX_MODE_PIXEL_DOUBLE 0x00008000
#define GFX_MODE_LINE_DOUBLE  0x00010000
#define GFX_MODE_TV_NTSC      0x00020000
#define GFX_MODE_TV_PAL       0x00040000
#define GFX_MODE_EXCLUDE_PLL  0x00080000
#define GFX_MODE_LOCK_TIMING  0x10000000


/* STRUCTURE DEFINITION */

typedef struct tagDISPLAYMODE
{
	/* DISPLAY MODE FLAGS */
	/* Specify valid color depths and the refresh rate. */

	unsigned long flags;

	/* TIMINGS */

	unsigned short hactive; 
	unsigned short hblankstart; 
	unsigned short hsyncstart; 
	unsigned short hsyncend; 
	unsigned short hblankend; 
	unsigned short htotal; 

	unsigned short vactive;
	unsigned short vblankstart;
	unsigned short vsyncstart;
	unsigned short vsyncend;
	unsigned short vblankend;
	unsigned short vtotal;

	/* CLOCK FREQUENCY */
	
	unsigned long frequency;

} DISPLAYMODE;


/* For Fixed timings */
typedef struct tagFIXEDTIMINGS
{
	/* DISPLAY MODE FLAGS */
	/* Specify valid color depths and the refresh rate. */

	int panelresx;
	int panelresy;
	unsigned short xres;
	unsigned short yres;
	
	/* TIMINGS */

	unsigned short hactive; 
	unsigned short hblankstart; 
	unsigned short hsyncstart; 
	unsigned short hsyncend; 
	unsigned short hblankend; 
	unsigned short htotal; 

	unsigned short vactive;
	unsigned short vblankstart;
	unsigned short vsyncstart;
	unsigned short vsyncend;
	unsigned short vblankend;
	unsigned short vtotal;

	/* CLOCK FREQUENCY */
	
	unsigned long frequency;

} FIXEDTIMINGS;

#endif /* !_gfx_mode_h */

/* END OF FILE */

